/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core.okio;

import androidx.datastore.core.Closeable;
import androidx.datastore.core.InterProcessCoordinator;
import androidx.datastore.core.ReadScope;
import androidx.datastore.core.StorageConnection;
import androidx.datastore.core.WriteScope;
import androidx.datastore.core.okio.AtomicBoolean;
import androidx.datastore.core.okio.OkioReadScope;
import androidx.datastore.core.okio.OkioSerializer;
import androidx.datastore.core.okio.OkioStorageConnection;
import androidx.datastore.core.okio.OkioWriteScope;
import java.io.IOException;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.sync.Mutex;
import kotlinx.coroutines.sync.MutexKt;
import okio.FileSystem;
import okio.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0015\u001a\u00020\rH\u0002J\b\u0010\u0016\u001a\u00020\rH\u0016JX\u0010\u0017\u001a\u0002H\u0018\"\u0004\b\u0001\u0010\u00182B\u0010\u0019\u001a>\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u001b\u0012\u0013\u0012\u00110\u001c\u00a2\u0006\f\b\u001d\u0012\b\b\u001e\u0012\u0004\b\b(\u001f\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00180 \u0012\u0006\u0012\u0004\u0018\u00010!0\u001a\u00a2\u0006\u0002\b\"H\u0096@\u00a2\u0006\u0002\u0010#J=\u0010$\u001a\u00020\r2-\u0010\u0019\u001a)\b\u0001\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000&\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0 \u0012\u0006\u0012\u0004\u0018\u00010!0%\u00a2\u0006\u0002\b\"H\u0096@\u00a2\u0006\u0002\u0010'R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Landroidx/datastore/core/okio/OkioStorageConnection;", "T", "Landroidx/datastore/core/StorageConnection;", "fileSystem", "Lokio/FileSystem;", "path", "Lokio/Path;", "serializer", "Landroidx/datastore/core/okio/OkioSerializer;", "coordinator", "Landroidx/datastore/core/InterProcessCoordinator;", "onClose", "Lkotlin/Function0;", "", "(Lokio/FileSystem;Lokio/Path;Landroidx/datastore/core/okio/OkioSerializer;Landroidx/datastore/core/InterProcessCoordinator;Lkotlin/jvm/functions/Function0;)V", "closed", "Landroidx/datastore/core/okio/AtomicBoolean;", "getCoordinator", "()Landroidx/datastore/core/InterProcessCoordinator;", "transactionMutex", "Lkotlinx/coroutines/sync/Mutex;", "checkNotClosed", "close", "readScope", "R", "block", "Lkotlin/Function3;", "Landroidx/datastore/core/ReadScope;", "", "Lkotlin/ParameterName;", "name", "locked", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function3;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeScope", "Lkotlin/Function2;", "Landroidx/datastore/core/WriteScope;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "datastore-core-okio"})
@SourceDebugExtension(value={"SMAP\nOkioStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkioStorage.kt\nandroidx/datastore/core/okio/OkioStorageConnection\n+ 2 Closeable.kt\nandroidx/datastore/core/CloseableKt\n+ 3 Mutex.kt\nkotlinx/coroutines/sync/MutexKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,230:1\n38#2,23:231\n38#2,23:262\n120#3,8:254\n129#3:285\n1#4:286\n*S KotlinDebug\n*F\n+ 1 OkioStorage.kt\nandroidx/datastore/core/okio/OkioStorageConnection\n*L\n112#1:231,23\n136#1:262,23\n129#1:254,8\n129#1:285\n*E\n"})
public final class OkioStorageConnection<T>
implements StorageConnection<T> {
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final Path path;
    @NotNull
    private final OkioSerializer<T> serializer;
    @NotNull
    private final InterProcessCoordinator coordinator;
    @NotNull
    private final Function0<Unit> onClose;
    @NotNull
    private final AtomicBoolean closed;
    @NotNull
    private final Mutex transactionMutex;

    public OkioStorageConnection(@NotNull FileSystem fileSystem, @NotNull Path path, @NotNull OkioSerializer<T> serializer, @NotNull InterProcessCoordinator coordinator, @NotNull Function0<Unit> onClose) {
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(serializer, (String)"serializer");
        Intrinsics.checkNotNullParameter((Object)coordinator, (String)"coordinator");
        Intrinsics.checkNotNullParameter(onClose, (String)"onClose");
        this.fileSystem = fileSystem;
        this.path = path;
        this.serializer = serializer;
        this.coordinator = coordinator;
        this.onClose = onClose;
        this.closed = new AtomicBoolean(false);
        this.transactionMutex = MutexKt.Mutex$default((boolean)false, (int)1, null);
    }

    @NotNull
    public InterProcessCoordinator getCoordinator() {
        return this.coordinator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public <R> Object readScope(@NotNull Function3<? super ReadScope<T>, ? super Boolean, ? super Continuation<? super R>, ? extends Object> var1_1, @NotNull Continuation<? super R> var2_2) {
        if (!(var2_2 instanceof readScope.1)) ** GOTO lbl-1000
        var13_3 = var2_2;
        if ((var13_3.label & -2147483648) != 0) {
            var13_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                boolean Z$0;
                /* synthetic */ Object result;
                final /* synthetic */ OkioStorageConnection<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.readScope(null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var14_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.checkNotClosed();
                lock = Mutex.DefaultImpls.tryLock$default((Mutex)this.transactionMutex, null, (int)1, null);
                $this$use$iv = (Closeable)new OkioReadScope<T>(this.fileSystem, this.path, this.serializer);
                $i$f$use = false;
                thrown$iv = null;
                it = (OkioReadScope)$this$use$iv;
                $i$a$-use-OkioStorageConnection$readScope$2 = false;
                $continuation.L$0 = this;
                $continuation.L$1 = $this$use$iv;
                $continuation.Z$0 = lock;
                $continuation.label = 1;
                v0 = block.invoke((Object)it, (Object)Boxing.boxBoolean((boolean)(lock != false)), $continuation);
                ** if (v0 != var14_5) goto lbl30
lbl29:
                // 1 sources

                return var14_5;
lbl30:
                // 1 sources

                ** GOTO lbl43
            }
            case 1: {
                $i$f$use = false;
                $i$a$-use-OkioStorageConnection$readScope$2 = false;
                lock = $continuation.Z$0;
                thrown$iv = null;
                $this$use$iv = (Closeable)$continuation.L$1;
                this = (OkioStorageConnection)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl43:
                    // 2 sources

                    var10_15 = v0;
                    try {
                        $this$use$iv.close();
                    }
                    catch (Throwable it) {
                        thrown$iv = it;
                    }
                    if (thrown$iv != null) {
                        throw thrown$iv;
                    }
                    var11_16 = var10_15;
                    return var11_16;
                    {
                        catch (Throwable t$iv) {
                            try {
                                thrown$iv = t$iv;
                            }
                            catch (Throwable var9_19) {
                                try {
                                    $this$use$iv.close();
                                }
                                catch (Throwable t$iv) {
                                    thrown$iv = t$iv;
                                }
                                if (thrown$iv != null) {
                                    throw thrown$iv;
                                }
                                throw var9_19;
                            }
                            try {
                                $this$use$iv.close();
                            }
                            catch (Throwable t$iv) {
                                if (thrown$iv != null) ** GOTO lbl76
                                thrown$iv = t$iv;
                                ** GOTO lbl77
lbl76:
                                // 1 sources

                                ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
                            }
lbl77:
                            // 3 sources

                            if (thrown$iv != null) {
                                throw thrown$iv;
                            }
                            throw new IllegalStateException("Unreachable code. If this occurs, please file a bug here:\n        https://b.corp.google.com/issues/new?component=907884&template=1466542".toString());
                        }
                    }
                }
                finally {
                    if (lock) {
                        Mutex.DefaultImpls.unlock$default((Mutex)this.transactionMutex, null, (int)1, null);
                    }
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Object writeScope(@NotNull Function2<? super WriteScope<T>, ? super Continuation<? super Unit>, ? extends Object> var1_1, @NotNull Continuation<? super Unit> var2_2) {
        if (!(var2_2 instanceof writeScope.1)) ** GOTO lbl-1000
        var16_3 = var2_2;
        if ((var16_3.label & -2147483648) != 0) {
            var16_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var2_2){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                final /* synthetic */ OkioStorageConnection<T> this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.writeScope(null, (Continuation<Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var17_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                this.checkNotClosed();
                v0 = this.path.parent();
                if (v0 == null) {
                    throw new IllegalStateException("must have a parent path".toString());
                }
                parentDir = v0;
                this.fileSystem.createDirectories(parentDir, false);
                $this$withLock_u24default$iv = this.transactionMutex;
                owner$iv = null;
                $i$f$withLock = false;
                $continuation.L$0 = this;
                $continuation.L$1 = block;
                $continuation.L$2 = parentDir;
                $continuation.L$3 = $this$withLock_u24default$iv;
                $continuation.label = 1;
                v1 = $this$withLock_u24default$iv.lock(owner$iv, (Continuation)$continuation);
                if (v1 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl41
            }
            case 1: {
                $i$f$withLock = false;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$3;
                parentDir = (Path)$continuation.L$2;
                block = (Function2)$continuation.L$1;
                this = (OkioStorageConnection)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl41:
                // 3 sources

                $i$a$-withLock$default-OkioStorageConnection$writeScope$2 = false;
                scratchPath = parentDir.resolve(this.path.name() + ".tmp");
                try {
                    this.fileSystem.delete(scratchPath, false);
                    $this$use$iv = (Closeable)new OkioWriteScope<T>(this.fileSystem, scratchPath, this.serializer);
                    $i$f$use = false;
                    thrown$iv = null;
                    try {
                        it /* !! */  = (OkioWriteScope)$this$use$iv;
                        $i$a$-use-OkioStorageConnection$writeScope$2$1 = false;
                        $continuation.L$0 = this;
                        $continuation.L$1 = $this$withLock_u24default$iv;
                        $continuation.L$2 = scratchPath;
                        $continuation.L$3 = $this$use$iv;
                        $continuation.label = 2;
                        v2 = block.invoke((Object)it /* !! */ , (Object)$continuation);
                    }
                    catch (Throwable t$iv) {
                        try {
                            thrown$iv = t$iv;
                        }
                        catch (Throwable var12_24) {
                            try {
                                $this$use$iv.close();
                            }
                            catch (Throwable t$iv) {
                                thrown$iv = t$iv;
                            }
                            if (thrown$iv == null) throw var12_24;
                            throw thrown$iv;
                        }
                        try {
                            $this$use$iv.close();
                        }
                        catch (Throwable t$iv) {
                            if (thrown$iv != null) ** GOTO lbl82
                            thrown$iv = t$iv;
                            ** GOTO lbl83
lbl82:
                            // 1 sources

                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv);
                        }
lbl83:
                        // 3 sources

                        if (thrown$iv == null) throw new IllegalStateException("Unreachable code. If this occurs, please file a bug here:\n        https://b.corp.google.com/issues/new?component=907884&template=1466542".toString());
                        throw thrown$iv;
                    }
                }
                catch (IOException ex) {
                    if (this.fileSystem.exists(scratchPath) == false) throw ex;
                    try {
                        this.fileSystem.delete(scratchPath);
                        throw ex;
                    }
                    catch (IOException var10_19) {
                        // empty catch block
                    }
                    throw ex;
                }
                v3 = v2;
                if (v2 == var17_5) {
                    return var17_5;
                }
                ** GOTO lbl115
            }
            case 2: {
                $i$f$withLock = false;
                $i$a$-withLock$default-OkioStorageConnection$writeScope$2 = false;
                $i$f$use = false;
                $i$a$-use-OkioStorageConnection$writeScope$2$1 = false;
                thrown$iv = null;
                $this$use$iv = (Closeable)$continuation.L$3;
                scratchPath = (Path)$continuation.L$2;
                owner$iv = null;
                $this$withLock_u24default$iv = (Mutex)$continuation.L$1;
                this = (OkioStorageConnection)$continuation.L$0;
                {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
lbl115:
                    // 2 sources

                    it /* !! */  = Unit.INSTANCE;
                }
                try {
                    $this$use$iv.close();
                }
                catch (Throwable t$iv) {
                    thrown$iv = t$iv;
                }
                if (thrown$iv != null) {
                    throw thrown$iv;
                }
                if (this.fileSystem.exists(scratchPath)) {
                    this.fileSystem.atomicMove(scratchPath, this.path);
                }
                var14_28 = Unit.INSTANCE;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final void checkNotClosed() {
        if (!(!this.closed.get())) {
            boolean bl = false;
            String string = "StorageConnection has already been disposed.";
            throw new IllegalStateException(string.toString());
        }
    }

    public void close() {
        this.closed.set(true);
        this.onClose.invoke();
    }
}

