/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.desktop.pages.settings;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Color;
import com.abdownloadmanager.desktop.pages.settings.ThemeInfo;
import com.abdownloadmanager.desktop.pages.settings.ThemeManagerKt;
import com.abdownloadmanager.desktop.storage.AppSettingsStorage;
import com.abdownloadmanager.resources.Res;
import com.abdownloadmanager.shared.ui.theme.DefaultThemes;
import com.abdownloadmanager.shared.utils.ui.MyColors;
import com.abdownloadmanager.shared.utils.ui.theme.ISystemThemeDetector;
import ir.amirab.util.compose.StringSourceKt;
import ir.amirab.util.flow.StateFlowUtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u000e\u0010'\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010)\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010*\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u0014J\u0006\u0010,\u001a\u00020(J\b\u0010/\u001a\u00020(H\u0002J\b\u00100\u001a\u00020(H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\r0\f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001d\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u001d\u0010\u0018\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0011R\u001d\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\f0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0011R\u001a\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0011R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u0011R\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0011R\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0017\u0010%\u001a\b\u0012\u0004\u0012\u00020\r0\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010\u0011R\u000e\u0010+\u001a\u00020$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010-\u001a\u0004\u0018\u00010.X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/abdownloadmanager/desktop/pages/settings/ThemeManager;", "", "scope", "Lkotlinx/coroutines/CoroutineScope;", "appSettings", "Lcom/abdownloadmanager/desktop/storage/AppSettingsStorage;", "osThemeDetector", "Lcom/abdownloadmanager/shared/utils/ui/theme/ISystemThemeDetector;", "<init>", "(Lkotlinx/coroutines/CoroutineScope;Lcom/abdownloadmanager/desktop/storage/AppSettingsStorage;Lcom/abdownloadmanager/shared/utils/ui/theme/ISystemThemeDetector;)V", "_availableThemes", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/abdownloadmanager/shared/utils/ui/MyColors;", "availableThemes", "Lkotlinx/coroutines/flow/StateFlow;", "getAvailableThemes", "()Lkotlinx/coroutines/flow/StateFlow;", "getThemeById", "themeId", "", "selectableThemes", "Lcom/abdownloadmanager/desktop/pages/settings/ThemeInfo;", "getSelectableThemes", "selectableDarkThemes", "getSelectableDarkThemes", "selectableLightThemes", "getSelectableLightThemes", "themeIds", "currentThemeInfo", "getCurrentThemeInfo", "selectedDarkThemeInfo", "getSelectedDarkThemeInfo", "selectedLightThemeInfo", "getSelectedLightThemeInfo", "osDarkModeFlow", "", "currentThemeColor", "getCurrentThemeColor", "setTheme", "", "setDarkTheme", "setLightTheme", "booted", "boot", "osUpdateFlowJob", "Lkotlinx/coroutines/Job;", "registerSystemThemeDetector", "unRegisterSystemThemeDetector", "Companion", "app"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nThemeManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ThemeManager.kt\ncom/abdownloadmanager/desktop/pages/settings/ThemeManager\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,216:1\n230#2,5:217\n1563#3:222\n1634#3,3:223\n774#3:226\n865#3,2:227\n1563#3:229\n1634#3,3:230\n774#3:233\n865#3,2:234\n1563#3:236\n1634#3,3:237\n1563#3:240\n1634#3,3:241\n*S KotlinDebug\n*F\n+ 1 ThemeManager.kt\ncom/abdownloadmanager/desktop/pages/settings/ThemeManager\n*L\n173#1:217,5\n52#1:222\n52#1:223,3\n59#1:226\n59#1:227,2\n59#1:229\n59#1:230,3\n63#1:233\n63#1:234,2\n63#1:236\n63#1:237,3\n67#1:240\n67#1:241,3\n*E\n"})
public final class ThemeManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final AppSettingsStorage appSettings;
    @NotNull
    private final ISystemThemeDetector osThemeDetector;
    @NotNull
    private final MutableStateFlow<List<MyColors>> _availableThemes;
    @NotNull
    private final StateFlow<List<MyColors>> availableThemes;
    @NotNull
    private final StateFlow<List<ThemeInfo>> selectableThemes;
    @NotNull
    private final StateFlow<List<ThemeInfo>> selectableDarkThemes;
    @NotNull
    private final StateFlow<List<ThemeInfo>> selectableLightThemes;
    @NotNull
    private final StateFlow<List<String>> themeIds;
    @NotNull
    private final StateFlow<ThemeInfo> currentThemeInfo;
    @NotNull
    private final StateFlow<ThemeInfo> selectedDarkThemeInfo;
    @NotNull
    private final StateFlow<ThemeInfo> selectedLightThemeInfo;
    @NotNull
    private MutableStateFlow<Boolean> osDarkModeFlow;
    @NotNull
    private final StateFlow<MyColors> currentThemeColor;
    private volatile boolean booted;
    @Nullable
    private Job osUpdateFlowJob;
    public static final int $stable = 8;
    @NotNull
    private static final List<MyColors> defaultThemes = DefaultThemes.INSTANCE.getAll();
    @NotNull
    private static final MyColors DefaultDarkTheme = DefaultThemes.INSTANCE.getDefaultDark();
    @NotNull
    private static final MyColors DefaultLightTheme = DefaultThemes.INSTANCE.getDefaultLight();
    @NotNull
    private static final MyColors DefaultTheme = DefaultDarkTheme;
    @NotNull
    private static final String DEFAULT_THEME_ID = DefaultTheme.getId();
    @NotNull
    private static final ThemeInfo systemThemeInfo = new ThemeInfo("system", StringSourceKt.asStringSource-HhCFyaE((String)Res.string.INSTANCE.getSystem-rO2e7mk()), Color.Companion.getGray-0d7_KjU(), null);

    public ThemeManager(@NotNull CoroutineScope scope, @NotNull AppSettingsStorage appSettings, @NotNull ISystemThemeDetector osThemeDetector) {
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)((Object)appSettings), (String)"appSettings");
        Intrinsics.checkNotNullParameter((Object)osThemeDetector, (String)"osThemeDetector");
        this.scope = scope;
        this.appSettings = appSettings;
        this.osThemeDetector = osThemeDetector;
        this._availableThemes = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.availableThemes = FlowKt.asStateFlow(this._availableThemes);
        this.selectableThemes = StateFlowUtilKt.mapStateFlow(this.availableThemes, arg_0 -> ThemeManager.selectableThemes$lambda$3(this, arg_0));
        this.selectableDarkThemes = StateFlowUtilKt.mapStateFlow(this.availableThemes, ThemeManager::selectableDarkThemes$lambda$6);
        this.selectableLightThemes = StateFlowUtilKt.mapStateFlow(this.availableThemes, ThemeManager::selectableLightThemes$lambda$9);
        this.themeIds = StateFlowUtilKt.mapStateFlow(this.selectableThemes, ThemeManager::themeIds$lambda$11);
        this.currentThemeInfo = StateFlowUtilKt.combineStateFlows((StateFlow)((StateFlow)this.appSettings.getTheme()), this.selectableThemes, ThemeManager::currentThemeInfo$lambda$14);
        this.selectedDarkThemeInfo = StateFlowUtilKt.combineStateFlows((StateFlow)((StateFlow)this.appSettings.getDefaultDarkTheme()), this.selectableThemes, ThemeManager::selectedDarkThemeInfo$lambda$17);
        this.selectedLightThemeInfo = StateFlowUtilKt.combineStateFlows((StateFlow)((StateFlow)this.appSettings.getDefaultLightTheme()), this.selectableThemes, ThemeManager::selectedLightThemeInfo$lambda$20);
        this.osDarkModeFlow = StateFlowKt.MutableStateFlow((Object)true);
        this.currentThemeColor = StateFlowUtilKt.combineStateFlows(this.themeIds, (StateFlow)((StateFlow)this.appSettings.getTheme()), (StateFlow)((StateFlow)this.appSettings.getDefaultDarkTheme()), (StateFlow)((StateFlow)this.appSettings.getDefaultLightTheme()), (StateFlow)((StateFlow)this.osDarkModeFlow), (arg_0, arg_1, arg_2, arg_3, arg_4) -> ThemeManager.currentThemeColor$lambda$21(this, arg_0, arg_1, arg_2, arg_3, arg_4));
    }

    @NotNull
    public final StateFlow<List<MyColors>> getAvailableThemes() {
        return this.availableThemes;
    }

    private final MyColors getThemeById(String themeId) {
        Object v0;
        block1: {
            Iterable iterable = (Iterable)this.availableThemes.getValue();
            for (Object t : iterable) {
                MyColors it = (MyColors)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)themeId)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @NotNull
    public final StateFlow<List<ThemeInfo>> getSelectableThemes() {
        return this.selectableThemes;
    }

    @NotNull
    public final StateFlow<List<ThemeInfo>> getSelectableDarkThemes() {
        return this.selectableDarkThemes;
    }

    @NotNull
    public final StateFlow<List<ThemeInfo>> getSelectableLightThemes() {
        return this.selectableLightThemes;
    }

    @NotNull
    public final StateFlow<ThemeInfo> getCurrentThemeInfo() {
        return this.currentThemeInfo;
    }

    @NotNull
    public final StateFlow<ThemeInfo> getSelectedDarkThemeInfo() {
        return this.selectedDarkThemeInfo;
    }

    @NotNull
    public final StateFlow<ThemeInfo> getSelectedLightThemeInfo() {
        return this.selectedLightThemeInfo;
    }

    @NotNull
    public final StateFlow<MyColors> getCurrentThemeColor() {
        return this.currentThemeColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setTheme(@NotNull String themeId) {
        Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
        ThemeManager themeManager = this;
        synchronized (themeManager) {
            boolean bl = false;
            if (Intrinsics.areEqual((Object)themeId, (Object)systemThemeInfo.getId())) {
                this.registerSystemThemeDetector();
            } else {
                this.unRegisterSystemThemeDetector();
            }
            if (((List)this.themeIds.getValue()).contains(themeId)) {
                this.appSettings.getTheme().setValue((Object)themeId);
            } else {
                this.appSettings.getTheme().setValue((Object)DEFAULT_THEME_ID);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setDarkTheme(@NotNull String themeId) {
        Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
        ThemeManager themeManager = this;
        synchronized (themeManager) {
            boolean bl = false;
            this.appSettings.getDefaultDarkTheme().setValue((Object)(((List)this.themeIds.getValue()).contains(themeId) ? themeId : DefaultDarkTheme.getId()));
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setLightTheme(@NotNull String themeId) {
        Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
        ThemeManager themeManager = this;
        synchronized (themeManager) {
            boolean bl = false;
            this.appSettings.getDefaultLightTheme().setValue((Object)(((List)this.themeIds.getValue()).contains(themeId) ? themeId : DefaultLightTheme.getId()));
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void boot() {
        List it;
        List nextValue$iv;
        Object prevValue$iv;
        if (this.booted) {
            return;
        }
        MutableStateFlow<List<MyColors>> $this$update$iv = this._availableThemes;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (List)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = CollectionsKt.plus((Collection)it, (Iterable)defaultThemes))));
        this.setTheme((String)this.appSettings.getTheme().getValue());
        this.booted = true;
    }

    private final void registerSystemThemeDetector() {
        Job job = this.osUpdateFlowJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        if (this.osThemeDetector.isSupported()) {
            this.osDarkModeFlow.setValue((Object)this.osThemeDetector.isDark());
            this.osUpdateFlowJob = FlowKt.launchIn((Flow)FlowKt.onEach((Flow)this.osThemeDetector.getSystemThemeFlow(), (Function2)((Function2)new Function2<Boolean, Continuation<? super Unit>, Object>(this, null){
                int label;
                /* synthetic */ boolean Z$0;
                final /* synthetic */ ThemeManager this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 */
                public final Object invokeSuspend(Object $result) {
                    boolean bl = this.Z$0;
                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            void isDark;
                            ResultKt.throwOnFailure((Object)$result);
                            ThemeManager.access$getOsDarkModeFlow$p(this.this$0).setValue((Object)Boxing.boxBoolean((isDark != false ? 1 : 0) != 0));
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.Z$0 = (Boolean)value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(boolean p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })), (CoroutineScope)this.scope);
        }
    }

    private final void unRegisterSystemThemeDetector() {
        Job job = this.osUpdateFlowJob;
        if (job != null) {
            Job.DefaultImpls.cancel$default((Job)job, null, (int)1, null);
        }
        this.osUpdateFlowJob = null;
    }

    /*
     * WARNING - void declaration
     */
    private static final List selectableThemes$lambda$3(ThemeManager this$0, List it) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        List list;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List $this$selectableThemes_u24lambda_u243_u24lambda_u242 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        if (this$0.osThemeDetector.isSupported()) {
            $this$selectableThemes_u24lambda_u243_u24lambda_u242.add(systemThemeInfo);
        }
        Iterable iterable = it;
        List list2 = $this$selectableThemes_u24lambda_u243_u24lambda_u242;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            MyColors myColors = (MyColors)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(ThemeManagerKt.access$toThemeInfo((MyColors)it2));
        }
        list2.addAll((List)destination$iv$iv);
        return CollectionsKt.build((List)list);
    }

    /*
     * WARNING - void declaration
     */
    private static final List selectableDarkThemes$lambda$6(List it) {
        void $this$mapTo$iv$iv;
        MyColors it2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$filter$iv = it;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (MyColors)element$iv$iv;
            boolean bl = false;
            if (!(!it2.isLight())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (MyColors)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThemeManagerKt.access$toThemeInfo(it2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List selectableLightThemes$lambda$9(List it) {
        void $this$mapTo$iv$iv;
        MyColors it2;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$filter$iv = it;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it2 = (MyColors)element$iv$iv;
            boolean bl = false;
            if (!it2.isLight()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it2 = (MyColors)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(ThemeManagerKt.access$toThemeInfo(it2));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final List themeIds$lambda$11(List it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Iterable $this$map$iv = it;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            ThemeInfo themeInfo = (ThemeInfo)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        return (List)destination$iv$iv;
    }

    private static final ThemeInfo currentThemeInfo$lambda$14(String themeId, List possibleThemes) {
        ThemeInfo themeInfo;
        Object v0;
        ThemeInfo it;
        Iterable iterable;
        block3: {
            Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
            Intrinsics.checkNotNullParameter((Object)possibleThemes, (String)"possibleThemes");
            iterable = possibleThemes;
            for (Object t : iterable) {
                it = (ThemeInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)themeId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((themeInfo = (ThemeInfo)v0) == null) {
            Object v2;
            block4: {
                iterable = possibleThemes;
                for (Object t : iterable) {
                    it = (ThemeInfo)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)DEFAULT_THEME_ID)) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            Intrinsics.checkNotNull(v2);
            themeInfo = v2;
        }
        return themeInfo;
    }

    private static final ThemeInfo selectedDarkThemeInfo$lambda$17(String themeId, List possibleThemes) {
        ThemeInfo themeInfo;
        Object v0;
        ThemeInfo it;
        Iterable iterable;
        block3: {
            Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
            Intrinsics.checkNotNullParameter((Object)possibleThemes, (String)"possibleThemes");
            iterable = possibleThemes;
            for (Object t : iterable) {
                it = (ThemeInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)themeId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((themeInfo = (ThemeInfo)v0) == null) {
            Object v2;
            block4: {
                iterable = possibleThemes;
                for (Object t : iterable) {
                    it = (ThemeInfo)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)DefaultDarkTheme.getId())) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            Intrinsics.checkNotNull(v2);
            themeInfo = v2;
        }
        return themeInfo;
    }

    private static final ThemeInfo selectedLightThemeInfo$lambda$20(String themeId, List possibleThemes) {
        ThemeInfo themeInfo;
        Object v0;
        ThemeInfo it;
        Iterable iterable;
        block3: {
            Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
            Intrinsics.checkNotNullParameter((Object)possibleThemes, (String)"possibleThemes");
            iterable = possibleThemes;
            for (Object t : iterable) {
                it = (ThemeInfo)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getId(), (Object)themeId)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        if ((themeInfo = (ThemeInfo)v0) == null) {
            Object v2;
            block4: {
                iterable = possibleThemes;
                for (Object t : iterable) {
                    it = (ThemeInfo)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)DefaultLightTheme.getId())) continue;
                    v2 = t;
                    break block4;
                }
                v2 = null;
            }
            Intrinsics.checkNotNull(v2);
            themeInfo = v2;
        }
        return themeInfo;
    }

    private static final MyColors currentThemeColor$lambda$21(ThemeManager this$0, List themes, String themeId, String userDefaultDarkThemeId, String userDefaultLightThemeId, boolean osThemeIsDark) {
        MyColors myColors;
        String id;
        Intrinsics.checkNotNullParameter((Object)themes, (String)"themes");
        Intrinsics.checkNotNullParameter((Object)themeId, (String)"themeId");
        Intrinsics.checkNotNullParameter((Object)userDefaultDarkThemeId, (String)"userDefaultDarkThemeId");
        Intrinsics.checkNotNullParameter((Object)userDefaultLightThemeId, (String)"userDefaultLightThemeId");
        String string2 = Intrinsics.areEqual((Object)themeId, (Object)systemThemeInfo.getId()) ? (osThemeIsDark ? userDefaultDarkThemeId : userDefaultLightThemeId) : (id = themeId);
        if (themes.contains(id)) {
            MyColors myColors2 = this$0.getThemeById(id);
            myColors = myColors2;
            Intrinsics.checkNotNull((Object)myColors2);
        } else {
            myColors = DefaultTheme;
        }
        return myColors;
    }

    public static final /* synthetic */ MutableStateFlow access$getOsDarkModeFlow$p(ThemeManager $this) {
        return $this.osDarkModeFlow;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u000e\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u0018"}, d2={"Lcom/abdownloadmanager/desktop/pages/settings/ThemeManager$Companion;", "", "<init>", "()V", "defaultThemes", "", "Lcom/abdownloadmanager/shared/utils/ui/MyColors;", "getDefaultThemes", "()Ljava/util/List;", "DefaultDarkTheme", "getDefaultDarkTheme", "()Lcom/abdownloadmanager/shared/utils/ui/MyColors;", "DefaultLightTheme", "getDefaultLightTheme", "DefaultTheme", "getDefaultTheme", "DEFAULT_THEME_ID", "", "getDEFAULT_THEME_ID", "()Ljava/lang/String;", "systemThemeInfo", "Lcom/abdownloadmanager/desktop/pages/settings/ThemeInfo;", "getSystemThemeInfo", "()Lcom/abdownloadmanager/desktop/pages/settings/ThemeInfo;", "app"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<MyColors> getDefaultThemes() {
            return defaultThemes;
        }

        @NotNull
        public final MyColors getDefaultDarkTheme() {
            return DefaultDarkTheme;
        }

        @NotNull
        public final MyColors getDefaultLightTheme() {
            return DefaultLightTheme;
        }

        @NotNull
        public final MyColors getDefaultTheme() {
            return DefaultTheme;
        }

        @NotNull
        public final String getDEFAULT_THEME_ID() {
            return DEFAULT_THEME_ID;
        }

        @NotNull
        public final ThemeInfo getSystemThemeInfo() {
            return systemThemeInfo;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

