/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.updateapplier;

import com.abdownloadmanager.updateapplier.UpdateInstaller;
import com.abdownloadmanager.updateapplier.UpdateInstallerFromArchiveFileKt;
import ir.amirab.util.platform.Platform;
import java.io.Closeable;
import java.io.File;
import java.util.Arrays;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okio.BufferedSource;
import okio.FileSystem;
import okio.Okio;
import okio.Path;
import okio.Source;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\r\u001a\u00020\u000eH\u0002J(\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J(\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/abdownloadmanager/updateapplier/UpdateInstallerFromArchiveFile;", "Lcom/abdownloadmanager/updateapplier/UpdateInstaller;", "archiveFile", "Ljava/io/File;", "installationFolder", "", "folderToExtractUpdate", "appFolderInArchive", "logDir", "<init>", "(Ljava/io/File;Ljava/lang/String;Ljava/io/File;Ljava/lang/String;Ljava/lang/String;)V", "getScriptPath", "logFile", "executeScript", "", "execInCMD", "scriptPath", "updateFolder", "execInBash", "installUpdate", "updater"})
@SourceDebugExtension(value={"SMAP\nUpdateInstallerFromArchiveFile.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UpdateInstallerFromArchiveFile.kt\ncom/abdownloadmanager/updateapplier/UpdateInstallerFromArchiveFile\n+ 2 Okio.kt\nokio/Okio__OkioKt\n*L\n1#1,185:1\n72#2:186\n58#2,22:187\n*S KotlinDebug\n*F\n+ 1 UpdateInstallerFromArchiveFile.kt\ncom/abdownloadmanager/updateapplier/UpdateInstallerFromArchiveFile\n*L\n45#1:186\n45#1:187,22\n*E\n"})
public final class UpdateInstallerFromArchiveFile
implements UpdateInstaller {
    @NotNull
    private final File archiveFile;
    @NotNull
    private final String installationFolder;
    @NotNull
    private final File folderToExtractUpdate;
    @NotNull
    private final String appFolderInArchive;
    @NotNull
    private final String logDir;

    public UpdateInstallerFromArchiveFile(@NotNull File archiveFile, @NotNull String installationFolder, @NotNull File folderToExtractUpdate, @NotNull String appFolderInArchive, @NotNull String logDir) {
        Intrinsics.checkNotNullParameter((Object)archiveFile, (String)"archiveFile");
        Intrinsics.checkNotNullParameter((Object)installationFolder, (String)"installationFolder");
        Intrinsics.checkNotNullParameter((Object)folderToExtractUpdate, (String)"folderToExtractUpdate");
        Intrinsics.checkNotNullParameter((Object)appFolderInArchive, (String)"appFolderInArchive");
        Intrinsics.checkNotNullParameter((Object)logDir, (String)"logDir");
        this.archiveFile = archiveFile;
        this.installationFolder = installationFolder;
        this.folderToExtractUpdate = folderToExtractUpdate;
        this.appFolderInArchive = appFolderInArchive;
        this.logDir = logDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final String getScriptPath(String logFile) {
        String string;
        String string2;
        Throwable thrown$iv;
        String scriptExtension;
        File updateFolder;
        Platform platform;
        block24: {
            String string3;
            platform = Platform.Companion.getCurrentPlatform();
            String updaterPath = "com/abdownloadmanager/updater";
            Platform platform2 = platform;
            if (Intrinsics.areEqual((Object)platform2, (Object)Platform.Desktop.Linux.INSTANCE)) {
                string3 = updaterPath + "/updater_linux.sh";
            } else if (Intrinsics.areEqual((Object)platform2, (Object)Platform.Desktop.MacOS.INSTANCE)) {
                string3 = updaterPath + "/updater_macos.sh";
            } else {
                if (!Intrinsics.areEqual((Object)platform2, (Object)Platform.Desktop.Windows.INSTANCE)) throw new IllegalStateException("script for this platform not found".toString());
                string3 = updaterPath + "/updater_windows.bat";
            }
            Path scriptForPlatform = Path.Companion.get$default((Path.Companion)Path.Companion, (String)string3, (boolean)false, (int)1, null);
            UpdateInstallerFromArchiveFileKt.access$extractTo(this.archiveFile, this.folderToExtractUpdate);
            updateFolder = FilesKt.resolve((File)this.folderToExtractUpdate, (String)this.appFolderInArchive);
            if (!updateFolder.exists()) {
                boolean $i$a$-require-UpdateInstallerFromArchiveFile$getScriptPath$23332 = false;
                String $i$a$-require-UpdateInstallerFromArchiveFile$getScriptPath$23332 = "Can't find required files for this update please update it manually";
                throw new IllegalArgumentException($i$a$-require-UpdateInstallerFromArchiveFile$getScriptPath$23332.toString());
            }
            scriptExtension = StringsKt.substringAfterLast((String)scriptForPlatform.toString(), (char)'.', (String)"");
            Closeable $this$use$iv = (Closeable)Okio.buffer((Source)FileSystem.RESOURCES.source(scriptForPlatform));
            boolean $i$f$use = false;
            thrown$iv = null;
            try {
                BufferedSource it = (BufferedSource)$this$use$iv;
                boolean bl = false;
                string2 = it.readUtf8();
            }
            catch (Throwable t$iv) {
                try {
                    thrown$iv = t$iv;
                    string2 = null;
                    break block24;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    block25: {
                        try {
                            Closeable closeable = $this$use$iv;
                            if (closeable != null) {
                                closeable.close();
                            }
                        }
                        catch (Throwable t$iv2) {
                            if (thrown$iv == null) {
                                thrown$iv = t$iv2;
                                break block25;
                            }
                            ExceptionsKt.addSuppressed((Throwable)thrown$iv, (Throwable)t$iv2);
                        }
                    }
                }
            }
            try {
                Closeable closeable = $this$use$iv;
                if (closeable != null) {
                    closeable.close();
                }
            }
            catch (Throwable t$iv) {
                thrown$iv = t$iv;
            }
        }
        String result$iv = string2;
        Throwable throwable = thrown$iv;
        if (throwable != null) {
            throw throwable;
        }
        String scriptContent = result$iv;
        Path scriptPathInTempFolder = Path.resolve$default((Path)FileSystem.SYSTEM_TEMPORARY_DIRECTORY, (String)("abdm-updater." + scriptExtension), (boolean)false, (int)2, null);
        FilesKt.writeText$default((File)scriptPathInTempFolder.toFile(), (String)scriptContent, null, (int)2, null);
        String scriptContentFile = scriptPathInTempFolder.toString();
        result$iv = platform;
        if (Intrinsics.areEqual((Object)result$iv, (Object)Platform.Desktop.Linux.INSTANCE)) {
            String string4 = updateFolder.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getPath(...)");
            string = this.execInBash(scriptContentFile, string4, this.installationFolder, logFile);
        } else if (Intrinsics.areEqual((Object)result$iv, (Object)Platform.Desktop.MacOS.INSTANCE)) {
            String string5 = updateFolder.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getPath(...)");
            string = this.execInBash(scriptContentFile, string5, this.installationFolder, logFile);
        } else {
            if (!Intrinsics.areEqual((Object)result$iv, (Object)Platform.Desktop.Windows.INSTANCE)) throw new IllegalStateException(("platform " + platform + " not supported").toString());
            String string6 = updateFolder.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getPath(...)");
            string = this.execInCMD(scriptContentFile, string6, this.installationFolder, logFile);
        }
        String commandToRun = string;
        Path scriptToRun = Path.resolve$default((Path)FileSystem.SYSTEM_TEMPORARY_DIRECTORY, (String)("abdm-updater.run." + scriptExtension), (boolean)false, (int)2, null);
        FilesKt.writeText$default((File)scriptToRun.toFile(), (String)commandToRun, null, (int)2, null);
        return scriptToRun.toString();
    }

    private final void executeScript() {
        ProcessBuilder processBuilder;
        String[] stringArray;
        File file;
        File $this$executeScript_u24lambda_u242 = file = new File(this.logDir, "update_log.txt");
        boolean bl = false;
        $this$executeScript_u24lambda_u242.getParentFile().mkdirs();
        String logFile = file.getPath();
        Intrinsics.checkNotNull((Object)logFile);
        String scriptPath = this.getScriptPath(logFile);
        Platform p = Platform.Companion.getCurrentPlatform();
        if (Intrinsics.areEqual((Object)p, (Object)Platform.Desktop.Linux.INSTANCE)) {
            var5_6 = new String[]{"bash", scriptPath};
            stringArray = var5_6;
        } else if (Intrinsics.areEqual((Object)p, (Object)Platform.Desktop.MacOS.INSTANCE)) {
            var5_6 = new String[]{"bash", scriptPath};
            stringArray = var5_6;
        } else if (Intrinsics.areEqual((Object)p, (Object)Platform.Desktop.Windows.INSTANCE)) {
            var5_6 = new String[]{"cmd", "/c", scriptPath};
            stringArray = var5_6;
        } else {
            throw new IllegalStateException(("platform: " + p + " not supported for updating by script").toString());
        }
        String[] command = stringArray;
        ProcessBuilder $this$executeScript_u24lambda_u243 = processBuilder = new ProcessBuilder(new String[0]).command(Arrays.copyOf(command, command.length));
        boolean bl2 = false;
        $this$executeScript_u24lambda_u243.environment().remove("_JPACKAGE_LAUNCHER");
        processBuilder.start();
    }

    private final String execInCMD(String scriptPath, String updateFolder, String installationFolder, String logFile) {
        return StringsKt.trimIndent((String)("\n            cmd /c \"\"" + scriptPath + "\" \"" + updateFolder + "\" \"" + installationFolder + "\" > \"" + logFile + "\" 2>&1\"\n        "));
    }

    private final String execInBash(String scriptPath, String updateFolder, String installationFolder, String logFile) {
        return StringsKt.trimIndent((String)("\n            bash \"" + scriptPath + "\" \"" + updateFolder + "\" \"" + installationFolder + "\" > \"" + logFile + "\" 2>&1 &\n        "));
    }

    @Override
    public void installUpdate() {
        this.executeScript();
    }
}

