/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.config;

import ir.amirab.util.config.Config;
import ir.amirab.util.config.ConfigKey;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003B\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0002\u0010\u0005J5\u0010\f\u001a\u00020\r\"\b\b\u0000\u0010\u000e*\u00020\n2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u00112\u0006\u0010\u0012\u001a\u0002H\u000eH\u0016\u00a2\u0006\u0002\u0010\u0013J+\u0010\u0014\u001a\u0004\u0018\u0001H\u000e\"\u0004\b\u0000\u0010\u000e2\u0006\u0010\u000f\u001a\u00020\b2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u0002H\u000e0\u0011H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0016\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000bH\u0016J\b\u0010\u0018\u001a\u00020\bH\u0016J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u001c\u001a\u00020\u001dH\u0016RB\u0010\u0006\u001a6\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0006\u0012\u0004\u0018\u00010\n \t*\u001a\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0006\u0012\u0004\u0018\u00010\n\u0018\u00010\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"Lir/amirab/util/config/MapConfig;", "Lir/amirab/util/config/Config;", "<init>", "()V", "config", "(Lir/amirab/util/config/Config;)V", "map", "", "", "kotlin.jvm.PlatformType", "", "", "put", "", "T", "key", "type", "Lir/amirab/util/config/Config$PrimitiveType;", "value", "(Ljava/lang/String;Lir/amirab/util/config/Config$PrimitiveType;Ljava/lang/Object;)V", "get", "(Ljava/lang/String;Lir/amirab/util/config/Config$PrimitiveType;)Ljava/lang/Object;", "removeKey", "toMap", "toString", "equals", "", "other", "hashCode", ""})
public final class MapConfig
implements Config {
    private final Map<String, Object> map;

    public MapConfig() {
        this.map = Collections.synchronizedMap(new LinkedHashMap());
    }

    public MapConfig(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this();
        this.map.putAll(config.toMap());
    }

    @Override
    public <T> void put(@NotNull String key, @NotNull Config.PrimitiveType<T> type, @NotNull T value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Map<String, Object> map = this.map;
        Intrinsics.checkNotNullExpressionValue(map, (String)"map");
        map.put(key, value);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull String key, @NotNull Config.PrimitiveType<T> type) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Object object = this.map.get(key);
        if (object == null) {
            return null;
        }
        Object value = object;
        Config.PrimitiveType.Companion.ensureIsPrimitive(value);
        return type.toType(value);
    }

    @Override
    public void removeKey(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.map.remove(key);
    }

    @Override
    @NotNull
    public Map<String, Object> toMap() {
        Map<String, Object> map = this.map;
        Intrinsics.checkNotNullExpressionValue(map, (String)"map");
        return MapsKt.toMap(map);
    }

    @NotNull
    public String toString() {
        return this.toMap().toString();
    }

    public boolean equals(@Nullable Object other) {
        Object object = other;
        Map<String, Object> otherMap = object instanceof MapConfig ? ((MapConfig)other).map : (object instanceof Config ? ((Config)other).toMap() : null);
        return Intrinsics.areEqual(this.map, otherMap);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public <T> void put(@NotNull ConfigKey.OfPrimitiveType<T> key, @NotNull T value) {
        Config.super.put(key, value);
    }

    @Override
    public void putInt(@NotNull String key, int value) {
        Config.super.putInt(key, value);
    }

    @Override
    public void putFloat(@NotNull String key, float value) {
        Config.super.putFloat(key, value);
    }

    @Override
    public void putLong(@NotNull String key, long value) {
        Config.super.putLong(key, value);
    }

    @Override
    public void putDouble(@NotNull String key, double value) {
        Config.super.putDouble(key, value);
    }

    @Override
    public void putBoolean(@NotNull String key, boolean value) {
        Config.super.putBoolean(key, value);
    }

    @Override
    public void putString(@NotNull String key, @NotNull String value) {
        Config.super.putString(key, value);
    }

    @Override
    @Nullable
    public <T> T get(@NotNull ConfigKey.OfPrimitiveType<T> key) {
        return Config.super.get(key);
    }

    @Override
    @Nullable
    public Integer getInt(@NotNull String key) {
        return Config.super.getInt(key);
    }

    @Override
    @Nullable
    public Float getFloat(@NotNull String key) {
        return Config.super.getFloat(key);
    }

    @Override
    @Nullable
    public Long getLong(@NotNull String key) {
        return Config.super.getLong(key);
    }

    @Override
    @Nullable
    public Double getDouble(@NotNull String key) {
        return Config.super.getDouble(key);
    }

    @Override
    @Nullable
    public Boolean getBoolean(@NotNull String key) {
        return Config.super.getBoolean(key);
    }

    @Override
    @Nullable
    public String getString(@NotNull String key) {
        return Config.super.getString(key);
    }

    @Override
    public void removeKey(@NotNull ConfigKey key) {
        Config.super.removeKey(key);
    }
}

