/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.desktop.dock.mac;

import androidx.compose.runtime.internal.StabilityInferred;
import com.sun.jna.Pointer;
import ir.amirab.util.desktop.PlatformDockToggler;
import ir.amirab.util.desktop.utils.mac.FoundationLibrary;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010!\u001a\u00020\"H\u0016J\b\u0010#\u001a\u00020\"H\u0016J\b\u0010$\u001a\u00020\"H\u0002J\u0010\u0010%\u001a\u00020\"2\u0006\u0010&\u001a\u00020\u001eH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u001b\u0010\u0011\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\r\u001a\u0004\b\u0012\u0010\u000bR\u001b\u0010\u0014\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\r\u001a\u0004\b\u0015\u0010\u000bR\u001b\u0010\u0017\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\r\u001a\u0004\b\u0018\u0010\u000bR\u001b\u0010\u001a\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\r\u001a\u0004\b\u001b\u0010\u000bR\u000e\u0010\u001d\u001a\u00020\u001eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u001eX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lir/amirab/util/desktop/dock/mac/MacDockToggler;", "Lir/amirab/util/desktop/PlatformDockToggler;", "<init>", "()V", "foundation", "Lir/amirab/util/desktop/utils/mac/FoundationLibrary;", "isAvailable", "", "nsAppClass", "Lcom/sun/jna/Pointer;", "getNsAppClass", "()Lcom/sun/jna/Pointer;", "nsAppClass$delegate", "Lkotlin/Lazy;", "sharedAppSel", "getSharedAppSel", "sharedAppSel$delegate", "setPolicySel", "getSetPolicySel", "setPolicySel$delegate", "nsRunningAppClass", "getNsRunningAppClass", "nsRunningAppClass$delegate", "currentAppSel", "getCurrentAppSel", "currentAppSel$delegate", "activateSel", "getActivateSel", "activateSel$delegate", "NSApplicationActivationPolicyRegular", "", "NSApplicationActivationPolicyAccessory", "NSApplicationActivateIgnoringOtherApps", "show", "", "hide", "hideAndKeepFocus", "setPolicy", "policy", "shared"})
@StabilityInferred(parameters=0)
public final class MacDockToggler
implements PlatformDockToggler {
    @Nullable
    private final FoundationLibrary foundation = FoundationLibrary.Companion.getINSTANCE();
    private final boolean isAvailable = this.foundation != null;
    @NotNull
    private final Lazy nsAppClass$delegate = LazyKt.lazy(() -> MacDockToggler.nsAppClass_delegate$lambda$0(this));
    @NotNull
    private final Lazy sharedAppSel$delegate = LazyKt.lazy(() -> MacDockToggler.sharedAppSel_delegate$lambda$1(this));
    @NotNull
    private final Lazy setPolicySel$delegate = LazyKt.lazy(() -> MacDockToggler.setPolicySel_delegate$lambda$2(this));
    @NotNull
    private final Lazy nsRunningAppClass$delegate = LazyKt.lazy(() -> MacDockToggler.nsRunningAppClass_delegate$lambda$3(this));
    @NotNull
    private final Lazy currentAppSel$delegate = LazyKt.lazy(() -> MacDockToggler.currentAppSel_delegate$lambda$4(this));
    @NotNull
    private final Lazy activateSel$delegate = LazyKt.lazy(() -> MacDockToggler.activateSel_delegate$lambda$5(this));
    private final int NSApplicationActivationPolicyRegular;
    private final int NSApplicationActivationPolicyAccessory;
    private final int NSApplicationActivateIgnoringOtherApps;
    public static final int $stable = 8;

    public MacDockToggler() {
        this.NSApplicationActivationPolicyAccessory = 1;
        this.NSApplicationActivateIgnoringOtherApps = 1;
    }

    private final Pointer getNsAppClass() {
        Lazy lazy = this.nsAppClass$delegate;
        return (Pointer)lazy.getValue();
    }

    private final Pointer getSharedAppSel() {
        Lazy lazy = this.sharedAppSel$delegate;
        return (Pointer)lazy.getValue();
    }

    private final Pointer getSetPolicySel() {
        Lazy lazy = this.setPolicySel$delegate;
        return (Pointer)lazy.getValue();
    }

    private final Pointer getNsRunningAppClass() {
        Lazy lazy = this.nsRunningAppClass$delegate;
        return (Pointer)lazy.getValue();
    }

    private final Pointer getCurrentAppSel() {
        Lazy lazy = this.currentAppSel$delegate;
        return (Pointer)lazy.getValue();
    }

    private final Pointer getActivateSel() {
        Lazy lazy = this.activateSel$delegate;
        return (Pointer)lazy.getValue();
    }

    @Override
    public void show() {
        if (this.isAvailable) {
            this.setPolicy(this.NSApplicationActivationPolicyRegular);
        }
    }

    @Override
    public void hide() {
        if (this.isAvailable) {
            this.hideAndKeepFocus();
        }
    }

    private final void hideAndKeepFocus() {
        FoundationLibrary foundationLibrary = this.foundation;
        Intrinsics.checkNotNull((Object)foundationLibrary);
        Pointer nsApp = foundationLibrary.objc_msgSend(this.getNsAppClass(), this.getSharedAppSel());
        Pointer nsRunningApp = this.foundation.objc_msgSend(this.getNsRunningAppClass(), this.getCurrentAppSel());
        this.foundation.objc_msgSend(nsApp, this.getSetPolicySel(), this.NSApplicationActivationPolicyAccessory);
        this.foundation.objc_msgSend(nsRunningApp, this.getActivateSel(), this.NSApplicationActivateIgnoringOtherApps);
    }

    private final void setPolicy(int policy) {
        FoundationLibrary foundationLibrary = this.foundation;
        Intrinsics.checkNotNull((Object)foundationLibrary);
        Pointer nsApp = foundationLibrary.objc_msgSend(this.getNsAppClass(), this.getSharedAppSel());
        this.foundation.objc_msgSend(nsApp, this.getSetPolicySel(), policy);
    }

    private static final Pointer nsAppClass_delegate$lambda$0(MacDockToggler this$0) {
        FoundationLibrary foundationLibrary = this$0.foundation;
        Intrinsics.checkNotNull((Object)foundationLibrary);
        return foundationLibrary.objc_getClass("NSApplication");
    }

    private static final Pointer sharedAppSel_delegate$lambda$1(MacDockToggler this$0) {
        FoundationLibrary foundationLibrary = this$0.foundation;
        Intrinsics.checkNotNull((Object)foundationLibrary);
        return foundationLibrary.sel_registerName("sharedApplication");
    }

    private static final Pointer setPolicySel_delegate$lambda$2(MacDockToggler this$0) {
        FoundationLibrary foundationLibrary = this$0.foundation;
        Intrinsics.checkNotNull((Object)foundationLibrary);
        return foundationLibrary.sel_registerName("setActivationPolicy:");
    }

    private static final Pointer nsRunningAppClass_delegate$lambda$3(MacDockToggler this$0) {
        FoundationLibrary foundationLibrary = this$0.foundation;
        Intrinsics.checkNotNull((Object)foundationLibrary);
        return foundationLibrary.objc_getClass("NSRunningApplication");
    }

    private static final Pointer currentAppSel_delegate$lambda$4(MacDockToggler this$0) {
        FoundationLibrary foundationLibrary = this$0.foundation;
        Intrinsics.checkNotNull((Object)foundationLibrary);
        return foundationLibrary.sel_registerName("currentApplication");
    }

    private static final Pointer activateSel_delegate$lambda$5(MacDockToggler this$0) {
        FoundationLibrary foundationLibrary = this$0.foundation;
        Intrinsics.checkNotNull((Object)foundationLibrary);
        return foundationLibrary.sel_registerName("activateWithOptions:");
    }
}

