/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics;

import androidx.annotation.RestrictTo;
import androidx.collection.FloatFloatPair;
import androidx.compose.ui.graphics.PathSegment;
import androidx.compose.ui.util.MathHelpersKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0002\n\u0002\b\u001d\u001a\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004H\u0007\u001a \u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a(\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a0\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a \u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0004H\u0007\u001a\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0004H\u0007\u001a\u0019\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004H\u0082\b\u001a \u0010\u0016\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0004H\u0002\u001a(\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007\u001a+\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0082\b\u001a2\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0002\u001a(\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u001a'\u0010!\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010#\u001a'\u0010$\u001a\u00020\"2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0000\u00a2\u0006\u0002\u0010#\u001a?\u0010%\u001a\u00020\"2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u00042\u0006\u0010'\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\b\b\u0002\u0010\u001c\u001a\u00020\u0019H\u0007\u00a2\u0006\u0002\u0010(\u001a\u0015\u0010)\u001a\u00020 *\u00020\u00012\u0006\u0010*\u001a\u00020\u0001H\u0080\b\u001a\u0015\u0010)\u001a\u00020 *\u00020\u00042\u0006\u0010*\u001a\u00020\u0004H\u0080\b\u001a\u0011\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004H\u0082\b\u001a \u0010-\u001a\u00020\u00192\u0006\u0010,\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002\u001a \u0010.\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0000\u001a \u00102\u001a\u00020 2\u0006\u00103\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u0004H\u0002\u001a0\u00106\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0000\u001a0\u00109\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u001bH\u0002\u001a\u0018\u0010;\u001a\u00020\u00192\u0006\u0010<\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001bH\u0002\u001a \u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001a\u0018\u0010A\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002\u001a0\u0010B\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u00042\u0006\u0010C\u001a\u00020\u001b2\u0006\u00108\u001a\u00020\u001bH\u0000\u001a(\u0010D\u001a\u00020\u00192\u0006\u0010/\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u00192\u0006\u00100\u001a\u00020\u00042\u0006\u00101\u001a\u00020\u0004H\u0002\u001a \u0010E\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010G\u001a\u00020\u001bH\u0002\u001a\u0018\u0010H\u001a\u00020\u00192\u0006\u0010F\u001a\u00020\u001b2\u0006\u0010I\u001a\u00020\u001bH\u0002\u001a0\u0010J\u001a\u00020?2\u0006\u0010@\u001a\u00020\u001b2\u0006\u0010K\u001a\u00020\u00192\u0006\u0010=\u001a\u00020\u001b2\u0006\u0010L\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\u0004H\u0002\u001aH\u0010M\u001a\u00020\u00042\u0006\u0010N\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u00042\u0006\u0010O\u001a\u00020\u00042\u0006\u00104\u001a\u00020\u00042\u0006\u0010P\u001a\u00020\u00042\u0006\u00105\u001a\u00020\u00042\u0006\u0010Q\u001a\u00020\u00042\u0006\u0010R\u001a\u00020\u0004H\u0000\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\"\u0019\u0010S\u001a\u00020\u0004*\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bT\u0010U\"\u0018\u0010V\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bW\u0010U\"\u0019\u0010X\u001a\u00020\u0004*\u00020\u00078\u00c2\u0002X\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bY\u0010U\"\u0018\u0010Z\u001a\u00020\u0004*\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b[\u0010U\u00a8\u0006\\"}, d2={"Tau", "", "Epsilon", "FloatEpsilon", "", "evaluateX", "segment", "Landroidx/compose/ui/graphics/PathSegment;", "t", "evaluateY", "evaluateLine", "p0y", "p1y", "evaluateQuadratic", "p0", "p1", "p2", "evaluateCubic", "p3", "findFirstRoot", "fraction", "findFirstLineRoot", "findFirstQuadraticRoot", "findFirstCubicRoot", "findLineRoot", "", "roots", "", "index", "findQuadraticRoots", "findDerivativeRoots", "horizontal", "", "computeHorizontalBounds", "Landroidx/collection/FloatFloatPair;", "(Landroidx/compose/ui/graphics/PathSegment;[FI)J", "computeVerticalBounds", "computeCubicVerticalBounds", "p2y", "p3y", "(FFFF[FI)J", "closeTo", "b", "clampValidRootInUnitRange", "r", "writeValidRootInUnitRange", "lineWinding", "points", "x", "y", "isQuadraticMonotonic", "y0", "y1", "y2", "quadraticWinding", "tmpQuadratics", "tmpRoots", "monotonicQuadraticWinding", "offset", "quadraticToMonotonicQuadratics", "quadratic", "dst", "splitQuadraticAt", "", "src", "unitDivide", "cubicWinding", "tmpCubics", "monotonicCubicWinding", "cubicToMonotonicCubics", "cubic", "tmpRoot", "findCubicExtremaY", "dstRoots", "splitCubicAt", "srcOffset", "dstOffset", "cubicArea", "x0", "x1", "x2", "x3", "y3", "startX", "getStartX", "(Landroidx/compose/ui/graphics/PathSegment;)F", "endX", "getEndX", "startY", "getStartY", "endY", "getEndY", "ui-graphics"})
@SourceDebugExtension(value={"SMAP\nBezier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,1010:1\n154#1:1011\n472#1:1012\n473#1:1023\n472#1:1024\n473#1:1035\n472#1:1036\n473#1:1047\n472#1:1048\n473#1:1059\n472#1:1060\n473#1:1071\n454#1:1072\n454#1:1073\n454#1:1074\n472#1:1075\n473#1:1086\n472#1:1087\n473#1:1098\n472#1:1099\n473#1:1110\n472#1:1121\n473#1:1132\n472#1:1133\n473#1:1144\n472#1:1145\n473#1:1156\n472#1:1157\n473#1:1168\n472#1:1169\n473#1:1180\n472#1:1181\n473#1:1192\n273#1:1193\n273#1:1194\n984#1:1195\n984#1:1196\n998#1:1197\n998#1:1198\n273#1:1199\n472#1:1210\n473#1:1221\n456#1:1222\n456#1:1225\n65#2,10:1013\n65#2,10:1025\n65#2,10:1037\n65#2,10:1049\n65#2,10:1061\n65#2,10:1076\n65#2,10:1088\n65#2,10:1100\n83#2,10:1111\n65#2,10:1122\n65#2,10:1134\n65#2,10:1146\n65#2,10:1158\n65#2,10:1170\n65#2,10:1182\n65#2,10:1200\n65#2,10:1211\n46#2:1223\n56#2:1224\n65#2,10:1226\n*S KotlinDebug\n*F\n+ 1 Bezier.kt\nandroidx/compose/ui/graphics/BezierKt\n*L\n131#1:1011\n131#1:1012\n131#1:1023\n154#1:1024\n154#1:1035\n174#1:1036\n174#1:1047\n177#1:1048\n177#1:1059\n179#1:1060\n179#1:1071\n208#1:1072\n210#1:1073\n212#1:1074\n215#1:1075\n215#1:1086\n220#1:1087\n220#1:1098\n223#1:1099\n223#1:1110\n244#1:1121\n244#1:1132\n247#1:1133\n247#1:1144\n250#1:1145\n250#1:1156\n254#1:1157\n254#1:1168\n257#1:1169\n257#1:1180\n264#1:1181\n264#1:1192\n347#1:1193\n362#1:1194\n381#1:1195\n382#1:1196\n406#1:1197\n407#1:1198\n439#1:1199\n483#1:1210\n483#1:1221\n618#1:1222\n805#1:1225\n131#1:1013,10\n154#1:1025,10\n174#1:1037,10\n177#1:1049,10\n179#1:1061,10\n215#1:1076,10\n220#1:1088,10\n223#1:1100,10\n240#1:1111,10\n244#1:1122,10\n247#1:1134,10\n250#1:1146,10\n254#1:1158,10\n257#1:1170,10\n264#1:1182,10\n472#1:1200,10\n483#1:1211,10\n783#1:1223\n786#1:1224\n845#1:1226,10\n*E\n"})
public final class BezierKt {
    private static final double Tau = Math.PI * 2;
    private static final double Epsilon = 1.0E-7;
    private static final float FloatEpsilon = 1.05E-6f;

    private static final float evaluateX(PathSegment segment, float t) {
        float f;
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 1: {
                f = points[0];
                break;
            }
            case 2: {
                f = BezierKt.evaluateLine(points[0], points[2], t);
                break;
            }
            case 3: {
                f = BezierKt.evaluateQuadratic(points[0], points[2], points[4], t);
                break;
            }
            case 4: {
                f = BezierKt.evaluateCubic(points[0], points[2], points[4], points[6], t);
                break;
            }
            default: {
                f = Float.NaN;
            }
        }
        return f;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float evaluateY(@NotNull PathSegment segment, float t) {
        float f;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 1: {
                f = points[1];
                break;
            }
            case 2: {
                f = BezierKt.evaluateLine(points[1], points[3], t);
                break;
            }
            case 3: {
                f = BezierKt.evaluateQuadratic(points[1], points[3], points[5], t);
                break;
            }
            case 4: {
                f = BezierKt.evaluateCubic(points[1], points[3], points[5], points[7], t);
                break;
            }
            default: {
                f = Float.NaN;
            }
        }
        return f;
    }

    private static final float evaluateLine(float p0y, float p1y, float t) {
        return (p1y - p0y) * t + p0y;
    }

    private static final float evaluateQuadratic(float p0, float p1, float p2, float t) {
        float by = 2.0f * (p1 - p0);
        float ay = p2 - 2.0f * p1 + p0;
        return (ay * t + by) * t + p0;
    }

    private static final float evaluateCubic(float p0, float p1, float p2, float p3, float t) {
        float a = p3 + 3.0f * (p1 - p2) - p0;
        float b = 3.0f * (p2 - 2.0f * p1 + p0);
        float c = 3.0f * (p1 - p0);
        return ((a * t + b) * t + c) * t + p0;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float evaluateCubic(float p1, float p2, float t) {
        float a = 0.33333334f + (p1 - p2);
        float b = p2 - 2.0f * p1;
        float c = p1;
        return 3.0f * ((a * t + b) * t + c) * t;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float findFirstRoot(@NotNull PathSegment segment, float fraction) {
        float f;
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 1: {
                f = Float.NaN;
                break;
            }
            case 2: {
                void $this$fastCoerceAtMost$iv$iv$iv$iv;
                void minimumValue$iv$iv$iv;
                void $this$fastCoerceIn$iv$iv$iv;
                void p1$iv;
                void p0$iv;
                float f2 = points[0] - fraction;
                float f3 = points[2] - fraction;
                boolean $i$f$findFirstLineRoot = false;
                void r$iv$iv = -p0$iv / (p1$iv - p0$iv);
                boolean $i$f$clampValidRootInUnitRange = false;
                void var8_8 = r$iv$iv;
                float f4 = 0.0f;
                float maximumValue$iv$iv$iv = 1.0f;
                boolean $i$f$fastCoerceIn = false;
                void $this$fastCoerceAtLeast$iv$iv$iv$iv = $this$fastCoerceIn$iv$iv$iv;
                boolean $i$f$fastCoerceAtLeast = false;
                $this$fastCoerceAtLeast$iv$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv$iv < minimumValue$iv$iv$iv ? minimumValue$iv$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv$iv;
                boolean $i$f$fastCoerceAtMost = false;
                float f5 = $this$fastCoerceAtMost$iv$iv$iv$iv > maximumValue$iv$iv$iv ? maximumValue$iv$iv$iv : $this$fastCoerceAtMost$iv$iv$iv$iv;
                float s$iv$iv = f5;
                if (Math.abs(s$iv$iv - r$iv$iv) > 1.05E-6f) {
                    f = Float.NaN;
                    break;
                }
                f = s$iv$iv;
                break;
            }
            case 3: {
                f = BezierKt.findFirstQuadraticRoot(points[0] - fraction, points[2] - fraction, points[4] - fraction);
                break;
            }
            case 5: {
                f = Float.NaN;
                break;
            }
            case 4: {
                f = BezierKt.findFirstCubicRoot(points[0] - fraction, points[2] - fraction, points[4] - fraction, points[6] - fraction);
                break;
            }
            case 6: {
                f = Float.NaN;
                break;
            }
            case 7: {
                f = Float.NaN;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    private static final float findFirstLineRoot(float p0, float p1) {
        void $this$fastCoerceAtMost$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        boolean $i$f$findFirstLineRoot = false;
        float r$iv = -p0 / (p1 - p0);
        boolean $i$f$clampValidRootInUnitRange = false;
        float f = r$iv;
        float f2 = 0.0f;
        float maximumValue$iv$iv = 1.0f;
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float s$iv = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
        return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final float findFirstQuadraticRoot(float p0, float p1, float p2) {
        double a = p0;
        double b = p1;
        double c = p2;
        double d = a - 2.0 * b + c;
        if (!(d == 0.0)) {
            float root;
            void $this$fastCoerceAtMost$iv$iv$iv;
            float minimumValue$iv$iv;
            float $this$fastCoerceIn$iv$iv;
            double v1 = -Math.sqrt(b * b - a * c);
            double v2 = -a + b;
            float r$iv = (float)(-(v1 + v2) / d);
            boolean $i$f$clampValidRootInUnitRange = false;
            float f = r$iv;
            float f2 = 0.0f;
            float maximumValue$iv$iv = 1.0f;
            boolean $i$f$fastCoerceIn = false;
            float $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            float s$iv = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
            float f3 = root = Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((v1 - v2) / d);
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv = r$iv;
            minimumValue$iv$iv = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
            $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost = false;
            s$iv = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
            return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
        }
        if (!(b == c)) {
            void $this$fastCoerceAtMost$iv$iv$iv;
            void minimumValue$iv$iv;
            void $this$fastCoerceIn$iv$iv;
            float r$iv = (float)((2.0 * b - c) / (2.0 * b - 2.0 * c));
            boolean $i$f$clampValidRootInUnitRange = false;
            float v2 = r$iv;
            float f = 0.0f;
            float maximumValue$iv$iv = 1.0f;
            boolean $i$f$fastCoerceIn = false;
            void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            float s$iv = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
            return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
        }
        return Float.NaN;
    }

    /*
     * WARNING - void declaration
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final float findFirstCubicRoot(float p0, float p1, float p2, float p3) {
        void $this$fastCoerceAtMost$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        double $this$closeTo$iv;
        double d;
        double a = 3.0 * ((double)p0 - 2.0 * (double)p1 + (double)p2);
        double b = 3.0 * (double)(p1 - p0);
        double c = p0;
        double d2 = d = (double)(-p0) + 3.0 * (double)(p1 - p2) + (double)p3;
        double b$iv = 0.0;
        boolean $i$f$closeTo = false;
        if (Math.abs((double)($this$closeTo$iv - b$iv)) < 1.0E-7) {
            float root;
            void $this$fastCoerceAtMost$iv$iv$iv2;
            float minimumValue$iv$iv2;
            float $this$fastCoerceIn$iv$iv2;
            $this$closeTo$iv = a;
            b$iv = 0.0;
            $i$f$closeTo = false;
            if (Math.abs($this$closeTo$iv - b$iv) < 1.0E-7) {
                void $this$fastCoerceAtMost$iv$iv$iv3;
                void minimumValue$iv$iv3;
                void $this$fastCoerceIn$iv$iv3;
                $this$closeTo$iv = b;
                b$iv = 0.0;
                $i$f$closeTo = false;
                if (Math.abs($this$closeTo$iv - b$iv) < 1.0E-7) {
                    return Float.NaN;
                }
                float r$iv = (float)(-c / b);
                boolean $i$f$clampValidRootInUnitRange = false;
                float b$iv2 = r$iv;
                float f = 0.0f;
                float maximumValue$iv$iv = 1.0f;
                boolean $i$f$fastCoerceIn = false;
                void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv3;
                boolean $i$f$fastCoerceAtLeast = false;
                $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv3 ? minimumValue$iv$iv3 : $this$fastCoerceAtLeast$iv$iv$iv;
                boolean $i$f$fastCoerceAtMost = false;
                float s$iv = $this$fastCoerceAtMost$iv$iv$iv3 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv3;
                return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
            }
            double q = Math.sqrt(b * b - 4.0 * a * c);
            double a2 = 2.0 * a;
            float r$iv = (float)((q - b) / a2);
            boolean $i$f$clampValidRootInUnitRange = false;
            float $i$f$fastCoerceAtMost = r$iv;
            float s$iv = 0.0f;
            float maximumValue$iv$iv = 1.0f;
            boolean $i$f$fastCoerceIn = false;
            float $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv2;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv2 ? minimumValue$iv$iv2 : $this$fastCoerceAtLeast$iv$iv$iv;
            boolean $i$f$fastCoerceAtMost2 = false;
            float s$iv2 = $this$fastCoerceAtMost$iv$iv$iv2 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv2;
            float f = root = Math.abs(s$iv2 - r$iv) > 1.05E-6f ? Float.NaN : s$iv2;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((-b - q) / a2);
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv2 = r$iv;
            minimumValue$iv$iv2 = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv2;
            $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv2 ? minimumValue$iv$iv2 : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost2 = false;
            s$iv2 = $this$fastCoerceAtMost$iv$iv$iv2 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv2;
            return Math.abs(s$iv2 - r$iv) > 1.05E-6f ? Float.NaN : s$iv2;
        }
        double o3 = (3.0 * (b /= d) - (a /= d) * a) / 9.0;
        double q2 = (2.0 * a * a * a - 9.0 * a * b + 27.0 * (c /= d)) / 54.0;
        double discriminant = q2 * q2 + o3 * o3 * o3;
        double a3 = a / 3.0;
        if (discriminant < 0.0) {
            float root;
            void $this$fastCoerceAtMost$iv$iv$iv4;
            float minimumValue$iv$iv4;
            float $this$fastCoerceIn$iv$iv4;
            void $this$fastCoerceAtMost$iv$iv22;
            void minimumValue$iv;
            void $this$fastCoerceIn$iv;
            double t;
            double mp33 = -(o3 * o3 * o3);
            double r = Math.sqrt(mp33);
            double d3 = t = -q2 / r;
            double d4 = -1.0;
            double maximumValue$iv = 1.0;
            boolean $i$f$fastCoerceIn22 = false;
            void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            double cosPhi = $this$fastCoerceAtMost$iv$iv22 > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv22;
            double phi = Math.acos(cosPhi);
            float t1 = 2.0f * MathHelpersKt.fastCbrt((float)((float)r));
            float r$iv = (float)((double)t1 * Math.cos(phi / 3.0) - a3);
            boolean $i$f$clampValidRootInUnitRange = false;
            float $i$f$fastCoerceIn22 = r$iv;
            float $this$fastCoerceAtMost$iv$iv22 = 0.0f;
            float maximumValue$iv$iv = 1.0f;
            boolean $i$f$fastCoerceIn = false;
            float $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv4;
            boolean $i$f$fastCoerceAtLeast2 = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv4 ? minimumValue$iv$iv4 : $this$fastCoerceAtLeast$iv$iv$iv;
            boolean $i$f$fastCoerceAtMost3 = false;
            float s$iv = $this$fastCoerceAtMost$iv$iv$iv4 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv4;
            float f = root = Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((double)t1 * Math.cos((phi + Math.PI * 2) / 3.0) - a3);
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv4 = r$iv;
            minimumValue$iv$iv4 = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv4;
            $i$f$fastCoerceAtLeast2 = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv4 ? minimumValue$iv$iv4 : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost3 = false;
            s$iv = $this$fastCoerceAtMost$iv$iv$iv4 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv4;
            float f2 = root = Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = (float)((double)t1 * Math.cos((phi + Math.PI * 4) / 3.0) - a3);
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv4 = r$iv;
            minimumValue$iv$iv4 = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv4;
            $i$f$fastCoerceAtLeast2 = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv4 ? minimumValue$iv$iv4 : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost3 = false;
            s$iv = $this$fastCoerceAtMost$iv$iv$iv4 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv4;
            return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
        }
        if (discriminant == 0.0) {
            float root;
            void $this$fastCoerceAtMost$iv$iv$iv5;
            float minimumValue$iv$iv5;
            float $this$fastCoerceIn$iv$iv5;
            float u1 = -MathHelpersKt.fastCbrt((float)((float)q2));
            float r$iv = 2.0f * u1 - (float)a3;
            boolean $i$f$clampValidRootInUnitRange = false;
            float t = r$iv;
            float s$iv = 0.0f;
            float maximumValue$iv$iv = 1.0f;
            boolean $i$f$fastCoerceIn = false;
            float $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv5;
            boolean $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv5 ? minimumValue$iv$iv5 : $this$fastCoerceAtLeast$iv$iv$iv;
            boolean $i$f$fastCoerceAtMost = false;
            float s$iv3 = $this$fastCoerceAtMost$iv$iv$iv5 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv5;
            float f = root = Math.abs(s$iv3 - r$iv) > 1.05E-6f ? Float.NaN : s$iv3;
            if (!Float.isNaN(root)) {
                return root;
            }
            r$iv = -u1 - (float)a3;
            $i$f$clampValidRootInUnitRange = false;
            $this$fastCoerceIn$iv$iv5 = r$iv;
            minimumValue$iv$iv5 = 0.0f;
            maximumValue$iv$iv = 1.0f;
            $i$f$fastCoerceIn = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv5;
            $i$f$fastCoerceAtLeast = false;
            $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv5 ? minimumValue$iv$iv5 : $this$fastCoerceAtLeast$iv$iv$iv;
            $i$f$fastCoerceAtMost = false;
            s$iv3 = $this$fastCoerceAtMost$iv$iv$iv5 > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv5;
            return Math.abs(s$iv3 - r$iv) > 1.05E-6f ? Float.NaN : s$iv3;
        }
        double sd = Math.sqrt(discriminant);
        float u1 = MathHelpersKt.fastCbrt((float)((float)(-q2 + sd)));
        float v1 = MathHelpersKt.fastCbrt((float)((float)(q2 + sd)));
        float r$iv = (float)((double)(u1 - v1) - a3);
        boolean $i$f$clampValidRootInUnitRange = false;
        float maximumValue$iv$iv = r$iv;
        float $i$f$fastCoerceIn = 0.0f;
        float maximumValue$iv$iv2 = 1.0f;
        boolean $i$f$fastCoerceIn2 = false;
        void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float s$iv = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv2 ? maximumValue$iv$iv2 : $this$fastCoerceAtMost$iv$iv$iv;
        return Math.abs(s$iv - r$iv) > 1.05E-6f ? Float.NaN : s$iv;
    }

    private static final int findLineRoot(float p0, float p1, float[] roots, int index) {
        boolean $i$f$findLineRoot = false;
        return BezierKt.writeValidRootInUnitRange(-p0 / (p1 - p0), roots, index);
    }

    static /* synthetic */ int findLineRoot$default(float p0, float p1, float[] roots, int index, int n, Object object) {
        if ((n & 8) != 0) {
            index = 0;
        }
        boolean $i$f$findLineRoot = false;
        return BezierKt.writeValidRootInUnitRange(-p0 / (p1 - p0), roots, index);
    }

    private static final int findQuadraticRoots(float p0, float p1, float p2, float[] roots, int index) {
        double a = p0;
        double b = p1;
        double c = p2;
        double d = a - 2.0 * b + c;
        int rootCount = 0;
        if (!(d == 0.0)) {
            double v1 = -Math.sqrt(b * b - a * c);
            double v2 = -a + b;
            rootCount += BezierKt.writeValidRootInUnitRange((float)(-(v1 + v2) / d), roots, index);
            if ((rootCount += BezierKt.writeValidRootInUnitRange((float)((v1 - v2) / d), roots, index + rootCount)) > 1) {
                float s = roots[index];
                float t = roots[index + 1];
                if (s > t) {
                    roots[index] = t;
                    roots[index + 1] = s;
                } else if (s == t) {
                    --rootCount;
                }
            }
        } else if (!(b == c)) {
            rootCount += BezierKt.writeValidRootInUnitRange((float)((2.0 * b - c) / (2.0 * b - 2.0 * c)), roots, index);
        }
        return rootCount;
    }

    static /* synthetic */ int findQuadraticRoots$default(float f, float f2, float f3, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x10) != 0) {
            n = 0;
        }
        return BezierKt.findQuadraticRoots(f, f2, f3, fArray, n);
    }

    private static final int findDerivativeRoots(PathSegment segment, boolean horizontal, float[] roots, int index) {
        int n;
        int offset = horizontal ? 0 : 1;
        float[] points = segment.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[segment.getType().ordinal()]) {
            case 3: {
                float d0 = (float)2 * (points[offset + 2] - points[offset + 0]);
                float d1 = (float)2 * (points[offset + 4] - points[offset + 2]);
                boolean $i$f$findLineRoot = false;
                n = BezierKt.writeValidRootInUnitRange(-d0 / (d1 - d0), roots, index);
                break;
            }
            case 4: {
                float d0 = 3.0f * (points[offset + 2] - points[offset + 0]);
                float d1 = 3.0f * (points[offset + 4] - points[offset + 2]);
                float d2 = 3.0f * (points[offset + 6] - points[offset + 4]);
                int count = BezierKt.findQuadraticRoots(d0, d1, d2, roots, index);
                float dd0 = 2.0f * (d1 - d0);
                float dd1 = 2.0f * (d2 - d1);
                int index$iv = index + count;
                boolean $i$f$findLineRoot = false;
                n = count + BezierKt.writeValidRootInUnitRange(-dd0 / (dd1 - dd0), roots, index$iv);
                break;
            }
            default: {
                n = 0;
            }
        }
        return n;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final long computeHorizontalBounds(@NotNull PathSegment segment, @NotNull float[] roots, int index) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        int count = BezierKt.findDerivativeRoots(segment, true, roots, index);
        PathSegment $this$startX$iv22 = segment;
        boolean $i$f$getStartX22 = false;
        float $this$startX$iv22 = $this$startX$iv22.getPoints()[0];
        float $i$f$getStartX22 = BezierKt.getEndX(segment);
        float minX = Math.min($this$startX$iv22, $i$f$getStartX22);
        PathSegment $this$startX$iv32 = segment;
        boolean $i$f$getStartX32 = false;
        float $this$startX$iv32 = $this$startX$iv32.getPoints()[0];
        float $i$f$getStartX32 = BezierKt.getEndX(segment);
        float maxX = Math.max($this$startX$iv32, $i$f$getStartX32);
        for (int i = 0; i < count; ++i) {
            float t = roots[i];
            float x = BezierKt.evaluateX(segment, t);
            minX = Math.min(minX, x);
            maxX = Math.max(maxX, x);
        }
        return FloatFloatPair.constructor-impl((float)minX, (float)maxX);
    }

    public static /* synthetic */ long computeHorizontalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeHorizontalBounds(pathSegment, fArray, n);
    }

    public static final long computeVerticalBounds(@NotNull PathSegment segment, @NotNull float[] roots, int index) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        int count = BezierKt.findDerivativeRoots(segment, false, roots, index);
        PathSegment $this$startY$iv22 = segment;
        boolean $i$f$getStartY22 = false;
        float $this$startY$iv22 = $this$startY$iv22.getPoints()[1];
        float $i$f$getStartY22 = BezierKt.getEndY(segment);
        float minY = Math.min($this$startY$iv22, $i$f$getStartY22);
        PathSegment $this$startY$iv32 = segment;
        boolean $i$f$getStartY32 = false;
        float $this$startY$iv32 = $this$startY$iv32.getPoints()[1];
        float $i$f$getStartY32 = BezierKt.getEndY(segment);
        float maxY = Math.max($this$startY$iv32, $i$f$getStartY32);
        for (int i = 0; i < count; ++i) {
            float t = roots[i];
            float x = BezierKt.evaluateY(segment, t);
            minY = Math.min(minY, x);
            maxY = Math.max(maxY, x);
        }
        return FloatFloatPair.constructor-impl((float)minY, (float)maxY);
    }

    public static /* synthetic */ long computeVerticalBounds$default(PathSegment pathSegment, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        return BezierKt.computeVerticalBounds(pathSegment, fArray, n);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static final long computeCubicVerticalBounds(float p0y, float p1y, float p2y, float p3y, @NotNull float[] roots, int index) {
        Intrinsics.checkNotNullParameter((Object)roots, (String)"roots");
        float d0 = 3.0f * (p1y - p0y);
        float d1 = 3.0f * (p2y - p1y);
        float d2 = 3.0f * (p3y - p2y);
        int count = BezierKt.findQuadraticRoots(d0, d1, d2, roots, index);
        float dd0 = 2.0f * (d1 - d0);
        float dd1 = 2.0f * (d2 - d1);
        int index$iv = index + count;
        boolean $i$f$findLineRoot = false;
        float minY = Math.min(p0y, p3y);
        float maxY = Math.max(p0y, p3y);
        int n = count += BezierKt.writeValidRootInUnitRange(-dd0 / (dd1 - dd0), roots, index$iv);
        for (int i = 0; i < n; ++i) {
            float t = roots[i];
            float y = BezierKt.evaluateCubic(p0y, p1y, p2y, p3y, t);
            minY = Math.min(minY, y);
            maxY = Math.max(maxY, y);
        }
        return FloatFloatPair.constructor-impl((float)minY, (float)maxY);
    }

    public static /* synthetic */ long computeCubicVerticalBounds$default(float f, float f2, float f3, float f4, float[] fArray, int n, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            n = 0;
        }
        return BezierKt.computeCubicVerticalBounds(f, f2, f3, f4, fArray, n);
    }

    public static final boolean closeTo(double $this$closeTo, double b) {
        boolean $i$f$closeTo = false;
        return Math.abs($this$closeTo - b) < 1.0E-7;
    }

    public static final boolean closeTo(float $this$closeTo, float b) {
        boolean $i$f$closeTo = false;
        return Math.abs($this$closeTo - b) < 1.05E-6f;
    }

    /*
     * WARNING - void declaration
     */
    private static final float clampValidRootInUnitRange(float r) {
        void $this$fastCoerceAtMost$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        boolean $i$f$clampValidRootInUnitRange = false;
        float f = r;
        float f2 = 0.0f;
        float maximumValue$iv = 1.0f;
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float s = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
        return Math.abs(s - r) > 1.05E-6f ? Float.NaN : s;
    }

    /*
     * WARNING - void declaration
     */
    private static final int writeValidRootInUnitRange(float r, float[] roots, int index) {
        float v;
        void $this$fastCoerceAtMost$iv$iv$iv;
        void minimumValue$iv$iv;
        void $this$fastCoerceIn$iv$iv;
        boolean $i$f$clampValidRootInUnitRange = false;
        float f = r;
        float f2 = 0.0f;
        float maximumValue$iv$iv = 1.0f;
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceIn$iv$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv$iv = $this$fastCoerceAtLeast$iv$iv$iv < minimumValue$iv$iv ? minimumValue$iv$iv : $this$fastCoerceAtLeast$iv$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        float s$iv = $this$fastCoerceAtMost$iv$iv$iv > maximumValue$iv$iv ? maximumValue$iv$iv : $this$fastCoerceAtMost$iv$iv$iv;
        roots[index] = v = Math.abs(s$iv - r) > 1.05E-6f ? Float.NaN : s$iv;
        return Float.isNaN(v) ? 0 : 1;
    }

    public static final int lineWinding(@NotNull float[] points, float x, float y) {
        float y0;
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        if (points.length < 4) {
            return 0;
        }
        float x0 = points[0];
        float yo = y0 = points[1];
        float x1 = points[2];
        float y1 = points[3];
        float dy = y1 - y0;
        int direction = 1;
        if (y0 > y1) {
            y0 = y1;
            y1 = yo;
            direction = -1;
        }
        if (y < y0 || y >= y1) {
            return 0;
        }
        float crossProduct = (x1 - x0) * (y - yo) - dy * (x - x0);
        if (crossProduct == 0.0f) {
            direction = 0;
        } else if ((int)Math.signum(crossProduct) == direction) {
            direction = 0;
        }
        return direction;
    }

    private static final boolean isQuadraticMonotonic(float y0, float y1, float y2) {
        return !(Math.signum(y0 - y1) + Math.signum(y1 - y2) == 0.0f);
    }

    public static final int quadraticWinding(@NotNull float[] points, float x, float y, @NotNull float[] tmpQuadratics, @NotNull float[] tmpRoots) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)tmpQuadratics, (String)"tmpQuadratics");
        Intrinsics.checkNotNullParameter((Object)tmpRoots, (String)"tmpRoots");
        float y0 = points[1];
        float y1 = points[3];
        float y2 = points[5];
        if (BezierKt.isQuadraticMonotonic(y0, y1, y2)) {
            return BezierKt.monotonicQuadraticWinding(points, 0, x, y, tmpRoots);
        }
        int rootCount = BezierKt.quadraticToMonotonicQuadratics(points, tmpQuadratics);
        int winding = BezierKt.monotonicQuadraticWinding(tmpQuadratics, 0, x, y, tmpRoots);
        if (rootCount > 0) {
            winding += BezierKt.monotonicQuadraticWinding(tmpQuadratics, 4, x, y, tmpRoots);
        }
        return winding;
    }

    private static final int monotonicQuadraticWinding(float[] points, int offset, float x, float y, float[] tmpRoots) {
        float xt;
        float y0 = points[offset + 1];
        float y2 = points[offset + 5];
        int direction = 1;
        if (y0 > y2) {
            float swap = y2;
            y2 = y0;
            y0 = swap;
            direction = -1;
        }
        if (y < y0 || y >= y2) {
            return 0;
        }
        y0 = points[offset + 1];
        float y1 = points[offset + 3];
        y2 = points[offset + 5];
        int rootCount = BezierKt.findQuadraticRoots$default(y0 - 2.0f * y1 + y2, 2.0f * (y1 - y0), y0 - y, tmpRoots, 0, 16, null);
        float $this$closeTo$iv = xt = rootCount == 0 ? points[(1 - direction) * 2] : BezierKt.evaluateQuadratic(points[0], points[2], points[4], tmpRoots[0]);
        boolean $i$f$closeTo = false;
        if (!(!(Math.abs($this$closeTo$iv - x) < 1.05E-6f) || x == points[4] && y == y2)) {
            return 0;
        }
        return xt < x ? direction : 0;
    }

    private static final int quadraticToMonotonicQuadratics(float[] quadratic, float[] dst) {
        if (quadratic.length < 6) {
            return 0;
        }
        if (dst.length < 6) {
            return 0;
        }
        float y0 = quadratic[1];
        float y1 = quadratic[3];
        float y2 = quadratic[5];
        if (!BezierKt.isQuadraticMonotonic(y0, y1, y2)) {
            float t = BezierKt.unitDivide(y0 - y1, y0 - y1 - y1 + y2);
            if (!Float.isNaN(t)) {
                BezierKt.splitQuadraticAt(quadratic, dst, t);
                return 1;
            }
            y1 = Math.abs(y0 - y1) < Math.abs(y1 - y2) ? y0 : y2;
        }
        ArraysKt.copyInto((float[])quadratic, (float[])dst, (int)0, (int)0, (int)6);
        dst[3] = y1;
        return 0;
    }

    private static final void splitQuadraticAt(float[] src, float[] dst, float t) {
        if (src.length < 6) {
            return;
        }
        if (dst.length < 10) {
            return;
        }
        float p0x = src[0];
        float p0y = src[1];
        float p1x = src[2];
        float p1y = src[3];
        float p2x = src[4];
        float p2y = src[5];
        float abx = MathHelpersKt.lerp((float)p0x, (float)p1x, (float)t);
        float aby = MathHelpersKt.lerp((float)p0y, (float)p1y, (float)t);
        dst[0] = p0x;
        dst[1] = p0y;
        dst[2] = abx;
        dst[3] = aby;
        float bcx = MathHelpersKt.lerp((float)p1x, (float)p2x, (float)t);
        float bcy = MathHelpersKt.lerp((float)p1y, (float)p2y, (float)t);
        float abcx = MathHelpersKt.lerp((float)abx, (float)bcx, (float)t);
        float abcy = MathHelpersKt.lerp((float)aby, (float)bcy, (float)t);
        dst[4] = abcx;
        dst[5] = abcy;
        dst[6] = bcx;
        dst[7] = bcy;
        dst[8] = p2x;
        dst[9] = p2y;
    }

    private static final float unitDivide(float x, float y) {
        float n = x;
        float d = y;
        if (n < 0.0f) {
            n = -n;
            d = -d;
        }
        if (d == 0.0f || n == 0.0f || n >= d) {
            return Float.NaN;
        }
        float r = n / d;
        if (r == 0.0f) {
            return Float.NaN;
        }
        return r;
    }

    public static final int cubicWinding(@NotNull float[] points, float x, float y, @NotNull float[] tmpCubics, @NotNull float[] tmpRoots) {
        Intrinsics.checkNotNullParameter((Object)points, (String)"points");
        Intrinsics.checkNotNullParameter((Object)tmpCubics, (String)"tmpCubics");
        Intrinsics.checkNotNullParameter((Object)tmpRoots, (String)"tmpRoots");
        int splits = BezierKt.cubicToMonotonicCubics(points, tmpCubics, tmpRoots);
        int winding = 0;
        int i = 0;
        if (i <= splits) {
            while (true) {
                winding += BezierKt.monotonicCubicWinding(tmpCubics, i * 3 * 2, x, y);
                if (i == splits) break;
                ++i;
            }
        }
        return winding;
    }

    private static final int monotonicCubicWinding(float[] points, int offset, float x, float y) {
        float xt;
        float y0 = points[offset + 1];
        float y3 = points[offset + 7];
        int direction = 1;
        if (y0 > y3) {
            float swap = y3;
            y3 = y0;
            y0 = swap;
            direction = -1;
        }
        if (y < y0 || y >= y3) {
            return 0;
        }
        float x0 = points[offset + 0];
        float x1 = points[offset + 2];
        float x2 = points[offset + 4];
        float x3 = points[offset + 6];
        boolean $i$f$fastMinOf = false;
        float min = Math.min(x0, Math.min(x1, Math.min(x2, x3)));
        if (x < min) {
            return 0;
        }
        boolean $i$f$fastMaxOf = false;
        float max = Math.max(x0, Math.max(x1, Math.max(x2, x3)));
        if (x > max) {
            return direction;
        }
        y0 = points[offset + 1];
        float y1 = points[offset + 3];
        float y2 = points[offset + 5];
        y3 = points[offset + 7];
        float root = BezierKt.findFirstCubicRoot(y0 - y, y1 - y, y2 - y, y3 - y);
        if (Float.isNaN(root)) {
            return 0;
        }
        float $this$closeTo$iv = xt = BezierKt.evaluateCubic(x0, x1, x2, x3, root);
        boolean $i$f$closeTo = false;
        if (!(!(Math.abs($this$closeTo$iv - x) < 1.05E-6f) || x == x3 && y == y3)) {
            return 0;
        }
        return xt < x ? direction : 0;
    }

    /*
     * WARNING - void declaration
     */
    private static final int cubicToMonotonicCubics(float[] cubic, float[] dst, float[] tmpRoot) {
        int rootCount = BezierKt.findCubicExtremaY(cubic, tmpRoot);
        if (rootCount == 0) {
            if (dst.length < 8) {
                return 0;
            }
            ArraysKt.copyInto((float[])cubic, (float[])dst, (int)0, (int)0, (int)8);
        } else {
            float lastT = 0.0f;
            int dstOffset = 0;
            float[] src = cubic;
            for (int i = 0; i < rootCount; ++i) {
                void $this$fastCoerceAtMost$iv$iv;
                void minimumValue$iv;
                void $this$fastCoerceIn$iv;
                float t = tmpRoot[i];
                float f = (t - lastT) / (1.0f - lastT);
                float f2 = 0.0f;
                float maximumValue$iv = 1.0f;
                boolean $i$f$fastCoerceIn = false;
                void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
                boolean $i$f$fastCoerceAtLeast = false;
                $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
                boolean $i$f$fastCoerceAtMost = false;
                lastT = t = $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
                BezierKt.splitCubicAt(src, dstOffset, dst, dstOffset, t);
                src = dst;
                dstOffset += 6;
            }
        }
        return rootCount;
    }

    private static final int findCubicExtremaY(float[] cubic, float[] dstRoots) {
        float a = cubic[1];
        float b = cubic[3];
        float c = cubic[5];
        float d = cubic[7];
        float A = d - a + 3.0f * (b - c);
        float B = 2.0f * (a - b - b - c);
        float C = b - a;
        return BezierKt.findQuadraticRoots(A, B, C, dstRoots, 0);
    }

    private static final void splitCubicAt(float[] src, int srcOffset, float[] dst, int dstOffset, float t) {
        if (src.length < srcOffset + 8) {
            return;
        }
        if (dst.length < dstOffset + 14) {
            return;
        }
        if (t >= 1.0f) {
            ArraysKt.copyInto((float[])src, (float[])dst, (int)dstOffset, (int)srcOffset, (int)8);
            float x = src[srcOffset + 6];
            float y = src[srcOffset + 7];
            dst[dstOffset + 8] = x;
            dst[dstOffset + 9] = y;
            dst[dstOffset + 10] = x;
            dst[dstOffset + 11] = y;
            dst[dstOffset + 12] = x;
            dst[dstOffset + 13] = y;
            return;
        }
        float p0x = src[srcOffset + 0];
        float p0y = src[srcOffset + 1];
        dst[dstOffset + 0] = p0x;
        dst[dstOffset + 1] = p0y;
        float p1x = src[srcOffset + 2];
        float p1y = src[srcOffset + 3];
        float abx = MathHelpersKt.lerp((float)p0x, (float)p1x, (float)t);
        float aby = MathHelpersKt.lerp((float)p0y, (float)p1y, (float)t);
        dst[dstOffset + 2] = abx;
        dst[dstOffset + 3] = aby;
        float p2x = src[srcOffset + 4];
        float p2y = src[srcOffset + 5];
        float bcx = MathHelpersKt.lerp((float)p1x, (float)p2x, (float)t);
        float bcy = MathHelpersKt.lerp((float)p1y, (float)p2y, (float)t);
        float abcx = MathHelpersKt.lerp((float)abx, (float)bcx, (float)t);
        float abcy = MathHelpersKt.lerp((float)aby, (float)bcy, (float)t);
        dst[dstOffset + 4] = abcx;
        dst[dstOffset + 5] = abcy;
        float p3x = src[srcOffset + 6];
        float p3y = src[srcOffset + 7];
        float cdx = MathHelpersKt.lerp((float)p2x, (float)p3x, (float)t);
        float cdy = MathHelpersKt.lerp((float)p2y, (float)p3y, (float)t);
        float bcdx = MathHelpersKt.lerp((float)bcx, (float)cdx, (float)t);
        float bcdy = MathHelpersKt.lerp((float)bcy, (float)cdy, (float)t);
        float abcdx = MathHelpersKt.lerp((float)abcx, (float)bcdx, (float)t);
        float abcdy = MathHelpersKt.lerp((float)abcy, (float)bcdy, (float)t);
        dst[dstOffset + 6] = abcdx;
        dst[dstOffset + 7] = abcdy;
        dst[dstOffset + 8] = bcdx;
        dst[dstOffset + 9] = bcdy;
        dst[dstOffset + 10] = cdx;
        dst[dstOffset + 11] = cdy;
        dst[dstOffset + 12] = p3x;
        dst[dstOffset + 13] = p3y;
    }

    public static final float cubicArea(float x0, float y0, float x1, float y1, float x2, float y2, float x3, float y3) {
        return ((y3 - y0) * (x1 + x2) - (x3 - x0) * (y1 + y2) + y1 * (x0 - x2) - x1 * (y0 - y2) + y3 * (x2 + x0 / 3.0f) - x3 * (y2 + y0 / 3.0f)) * 3.0f / 20.0f;
    }

    private static final float getStartX(PathSegment $this$startX) {
        boolean $i$f$getStartX = false;
        return $this$startX.getPoints()[0];
    }

    private static final float getEndX(PathSegment $this$endX) {
        int n;
        float[] fArray = $this$endX.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[$this$endX.getType().ordinal()]) {
            case 2: {
                n = 2;
                break;
            }
            case 3: {
                n = 4;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 4: {
                n = 6;
                break;
            }
            default: {
                n = 0;
            }
        }
        return fArray[n];
    }

    private static final float getStartY(PathSegment $this$startY) {
        boolean $i$f$getStartY = false;
        return $this$startY.getPoints()[1];
    }

    private static final float getEndY(PathSegment $this$endY) {
        int n;
        float[] fArray = $this$endY.getPoints();
        switch (WhenMappings.$EnumSwitchMapping$0[$this$endY.getType().ordinal()]) {
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 5;
                break;
            }
            case 5: {
                n = 5;
                break;
            }
            case 4: {
                n = 7;
                break;
            }
            default: {
                n = 0;
            }
        }
        return fArray[n];
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathSegment.Type.values().length];
            try {
                nArray[PathSegment.Type.Move.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Line.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Quadratic.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Cubic.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Conic.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Close.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathSegment.Type.Done.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

