/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.osfileutil;

import ir.amirab.util.osfileutil.FileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\fH\u0016J\f\u0010\r\u001a\u00020\u0005*\u00020\u0007H\u0002J\u0010\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\fH\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0010\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H$J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0007H$\u00a8\u0006\u0014"}, d2={"Lir/amirab/util/osfileutil/FileUtilsBase;", "Lir/amirab/util/osfileutil/FileUtils;", "<init>", "()V", "openFile", "", "file", "Ljava/io/File;", "openFolderOfFile", "openFolder", "folder", "canWriteInThisFolder", "", "canUseThisAsFolder", "preparedFile", "isRemovableStorage", "path", "openFileInternal", "openFolderOfFileInternal", "openFolderInternal", "utils"})
@SourceDebugExtension(value={"SMAP\nFileUtilsBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileUtilsBase.kt\nir/amirab/util/osfileutil/FileUtilsBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,73:1\n1#2:74\n*E\n"})
public abstract class FileUtilsBase
implements FileUtils {
    @Override
    public boolean openFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.openFileInternal(this.preparedFile(file));
    }

    @Override
    public boolean openFolderOfFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return this.openFolderOfFileInternal(this.preparedFile(file));
    }

    @Override
    public boolean openFolder(@NotNull File folder) {
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        return this.openFolderInternal(this.preparedFile(folder));
    }

    @Override
    public boolean canWriteInThisFolder(@NotNull String folder) {
        Object object;
        Object $this$canWriteInThisFolder_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Object object2 = this;
        try {
            $this$canWriteInThisFolder_u24lambda_u240 = object2;
            boolean bl = false;
            $this$canWriteInThisFolder_u24lambda_u240 = Result.constructor-impl((Object)super.canUseThisAsFolder(new File(folder)));
        }
        catch (Throwable bl) {
            $this$canWriteInThisFolder_u24lambda_u240 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        object2 = $this$canWriteInThisFolder_u24lambda_u240;
        Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
        if (throwable == null) {
            object = object2;
        } else {
            Throwable it = throwable;
            boolean bl = false;
            object = false;
        }
        return (Boolean)object;
    }

    private final boolean canUseThisAsFolder(File $this$canUseThisAsFolder) {
        for (File current = $this$canUseThisAsFolder; current != null; current = current.getParentFile()) {
            if (!current.exists()) continue;
            return current.isDirectory();
        }
        return false;
    }

    private final File preparedFile(File file) {
        File file2 = file.getCanonicalFile().getAbsoluteFile();
        if (!file2.exists()) {
            throw new FileNotFoundException(file2 + " not found");
        }
        Intrinsics.checkNotNull((Object)file2);
        return file2;
    }

    @Override
    public boolean isRemovableStorage(@NotNull String path) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Object object2 = this;
            try {
                Object isRemovable;
                FileUtilsBase $this$isRemovableStorage_u24lambda_u242 = object2;
                boolean bl = false;
                Path path2 = Paths.get(path, new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"get(...)");
                Path path3 = path2.toAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"toAbsolutePath(...)");
                FileStore fileStore = Files.getFileStore(path3);
                Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"getFileStore(...)");
                FileStore store = fileStore;
                if (store.supportsFileAttributeView("basic") && (isRemovable = store.getAttribute("volume:isRemovable")) instanceof Boolean) {
                    return (Boolean)isRemovable;
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) break block3;
            Object it = object = throwable;
            boolean bl = false;
            ((Throwable)it).printStackTrace();
        }
        return false;
    }

    protected abstract boolean openFileInternal(@NotNull File var1);

    protected abstract boolean openFolderOfFileInternal(@NotNull File var1);

    protected abstract boolean openFolderInternal(@NotNull File var1);
}

