/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.startup;

import ir.amirab.util.platform.Platform;
import ir.amirab.util.startup.AbstractStartupManager;
import ir.amirab.util.startup.HeadlessStartup;
import ir.amirab.util.startup.MacOSStartup;
import ir.amirab.util.startup.UnixXDGStartup;
import ir.amirab.util.startup.Utils;
import ir.amirab.util.startup.WindowsStartup;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u00072\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00070\n2\u0006\u0010\u000b\u001a\u00020\u0007J\b\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000e"}, d2={"Lir/amirab/util/startup/Startup;", "", "<init>", "()V", "getStartUpManagerForDesktop", "Lir/amirab/util/startup/AbstractStartupManager;", "name", "", "path", "args", "", "packageName", "noImplStartUpManager", "Lir/amirab/util/startup/HeadlessStartup;", "auto-start"})
public final class Startup {
    @NotNull
    public static final Startup INSTANCE = new Startup();

    private Startup() {
    }

    @NotNull
    public final AbstractStartupManager getStartUpManagerForDesktop(@NotNull String name, @Nullable String path, @NotNull List<String> args, @NotNull String packageName) throws Exception {
        AbstractStartupManager abstractStartupManager;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        if (path == null) {
            return this.noImplStartUpManager();
        }
        Platform os = Platform.Companion.getCurrentPlatform();
        Platform platform = os;
        if (Intrinsics.areEqual((Object)platform, (Object)Platform.Desktop.Linux.INSTANCE)) {
            abstractStartupManager = Utils.INSTANCE.isHeadless() ? (AbstractStartupManager)new HeadlessStartup(name, path, args) : (AbstractStartupManager)new UnixXDGStartup(name, path, args, packageName);
        } else if (Intrinsics.areEqual((Object)platform, (Object)Platform.Desktop.MacOS.INSTANCE)) {
            abstractStartupManager = new MacOSStartup(name, path, args);
        } else if (Intrinsics.areEqual((Object)platform, (Object)Platform.Desktop.Windows.INSTANCE)) {
            abstractStartupManager = new WindowsStartup(name, path, args);
        } else {
            if (Intrinsics.areEqual((Object)platform, (Object)Platform.Android.INSTANCE)) {
                throw new IllegalStateException("this code should not be called in android".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        AbstractStartupManager startup = abstractStartupManager;
        return startup;
    }

    private final HeadlessStartup noImplStartUpManager() {
        return new HeadlessStartup("", "", CollectionsKt.emptyList());
    }
}

