/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.startup;

import ir.amirab.util.startup.AbstractStartupManager;
import ir.amirab.util.startup.Utils;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00030\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\u0018\u0010\u000e\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u00a8\u0006\u0012"}, d2={"Lir/amirab/util/startup/MacOSStartup;", "Lir/amirab/util/startup/AbstractStartupManager;", "name", "", "path", "args", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getFile", "Ljava/io/File;", "install", "", "uninstall", "runLaunchctlCommand", "command", "filePath", "Companion", "auto-start"})
@SourceDebugExtension(value={"SMAP\nMacOSStartup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MacOSStartup.kt\nir/amirab/util/startup/MacOSStartup\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,87:1\n1869#2,2:88\n1#3:90\n*S KotlinDebug\n*F\n+ 1 MacOSStartup.kt\nir/amirab/util/startup/MacOSStartup\n*L\n38#1:88,2\n*E\n"})
public final class MacOSStartup
extends AbstractStartupManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String UNLOAD_COMMAND = "unload";
    @NotNull
    private static final String LOAD_COMMAND = "load";

    public MacOSStartup(@NotNull String name, @NotNull String path, @NotNull List<String> args) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(args, (String)"args");
        super(name, path, args);
    }

    private final File getFile() {
        if (!Companion.getLaunchAgentsDir().exists()) {
            Companion.getLaunchAgentsDir().mkdirs();
        }
        return new File(Companion.getLaunchAgentsDir(), super.getName() + ".plist");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install() throws Exception {
        File file = this.getFile();
        Object object = new StringBuilder();
        StringBuilder $this$install_u24lambda_u241 = object;
        int n = 0;
        $this$install_u24lambda_u241.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append('\n');
        $this$install_u24lambda_u241.append("<plist version=\"1.0\">").append('\n');
        $this$install_u24lambda_u241.append("<dict>").append('\n');
        $this$install_u24lambda_u241.append("\t<key>Label</key>").append('\n');
        $this$install_u24lambda_u241.append("\t<string>" + super.getName() + ".startup</string>").append('\n');
        $this$install_u24lambda_u241.append("\t<key>ProgramArguments</key>").append('\n');
        $this$install_u24lambda_u241.append("\t<array>").append('\n');
        $this$install_u24lambda_u241.append("\t\t<string>/usr/bin/open</string>").append('\n');
        $this$install_u24lambda_u241.append("\t\t<string>-a</string>").append('\n');
        $this$install_u24lambda_u241.append("\t\t<string>" + super.getPath() + "</string>").append('\n');
        $this$install_u24lambda_u241.append("\t\t<string>--args</string>").append('\n');
        Object $this$forEach$iv = this.getArgs();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv = iterator.next();
            String it = (String)element$iv;
            boolean bl = false;
            $this$install_u24lambda_u241.append("\t\t<string>" + it + "</string>").append('\n');
        }
        $this$install_u24lambda_u241.append("\t</array>").append('\n');
        $this$install_u24lambda_u241.append("\t<key>RunAtLoad</key>").append('\n');
        $this$install_u24lambda_u241.append("\t<true/>").append('\n');
        $this$install_u24lambda_u241.append("\t<key>LimitLoadToSessionType</key>").append('\n');
        $this$install_u24lambda_u241.append("\t<string>Aqua</string>").append('\n');
        $this$install_u24lambda_u241.append("</dict>").append('\n');
        $this$install_u24lambda_u241.append("</plist>").append('\n');
        String plistContent = ((StringBuilder)object).toString();
        object = file;
        Object object2 = Charsets.UTF_8;
        n = 8192;
        $this$forEach$iv = object;
        $this$forEach$iv = new OutputStreamWriter((OutputStream)new FileOutputStream((File)$this$forEach$iv), (Charset)object2);
        object = $this$forEach$iv instanceof BufferedWriter ? (BufferedWriter)$this$forEach$iv : new BufferedWriter((Writer)$this$forEach$iv, n);
        object2 = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl = false;
            it.write(plistContent);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
        }
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        this.runLaunchctlCommand(LOAD_COMMAND, string);
    }

    @Override
    public void uninstall() {
        File file = this.getFile();
        if (file.exists()) {
            String string = file.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            this.runLaunchctlCommand(UNLOAD_COMMAND, string);
            file.delete();
        }
    }

    private final void runLaunchctlCommand(String command, String filePath) {
        String[] stringArray = new String[]{"launchctl", command, filePath};
        new ProcessBuilder(stringArray).inheritIO().start().waitFor();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lir/amirab/util/startup/MacOSStartup$Companion;", "", "<init>", "()V", "launchAgentsDir", "Ljava/io/File;", "getLaunchAgentsDir", "()Ljava/io/File;", "UNLOAD_COMMAND", "", "LOAD_COMMAND", "auto-start"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final File getLaunchAgentsDir() throws Exception {
            String home = System.getProperty("user.home");
            if (Utils.INSTANCE.isRoot()) {
                home = "";
            }
            return new File(home + "/Library/LaunchAgents/");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

