/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.shared.utils.proxy;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.shared.utils.proxy.IProxyStorage;
import com.abdownloadmanager.shared.utils.proxy.MySocksProxyAuthenticator;
import com.abdownloadmanager.shared.utils.proxy.ProxyData;
import com.abdownloadmanager.shared.utils.proxy.ProxyMode;
import com.abdownloadmanager.shared.utils.proxy.ProxyRules;
import com.abdownloadmanager.shared.utils.proxy.ProxyWithRules;
import ir.amirab.downloader.connection.proxy.Proxy;
import ir.amirab.downloader.connection.proxy.ProxyStrategy;
import ir.amirab.downloader.connection.proxy.ProxyStrategyProvider;
import ir.amirab.util.StringUtilKt;
import ir.amirab.util.UrlUtils;
import java.net.Authenticator;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0016"}, d2={"Lcom/abdownloadmanager/shared/utils/proxy/ProxyManager;", "Lir/amirab/downloader/connection/proxy/ProxyStrategyProvider;", "storage", "Lcom/abdownloadmanager/shared/utils/proxy/IProxyStorage;", "<init>", "(Lcom/abdownloadmanager/shared/utils/proxy/IProxyStorage;)V", "getStorage", "()Lcom/abdownloadmanager/shared/utils/proxy/IProxyStorage;", "proxyData", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/abdownloadmanager/shared/utils/proxy/ProxyData;", "getProxyData", "()Lkotlinx/coroutines/flow/MutableStateFlow;", "getProxyModeForThisURL", "Lir/amirab/downloader/connection/proxy/ProxyStrategy;", "url", "", "shouldUseProxyFor", "", "rules", "Lcom/abdownloadmanager/shared/utils/proxy/ProxyRules;", "getProxyStrategyFor", "app-utils"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nProxyManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProxyManager.kt\ncom/abdownloadmanager/shared/utils/proxy/ProxyManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1761#2,3:86\n*S KotlinDebug\n*F\n+ 1 ProxyManager.kt\ncom/abdownloadmanager/shared/utils/proxy/ProxyManager\n*L\n53#1:86,3\n*E\n"})
public final class ProxyManager
implements ProxyStrategyProvider {
    @NotNull
    private final IProxyStorage storage;
    @NotNull
    private final MutableStateFlow<ProxyData> proxyData;
    public static final int $stable = 8;

    public ProxyManager(@NotNull IProxyStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
        this.proxyData = this.storage.getProxyDataFlow();
        MySocksProxyAuthenticator mySocksProxyAuthenticator = new MySocksProxyAuthenticator((Function0<Proxy>)((Function0)() -> ProxyManager._init_$lambda$0(this)));
        Authenticator.setDefault(mySocksProxyAuthenticator);
    }

    @NotNull
    public final IProxyStorage getStorage() {
        return this.storage;
    }

    @NotNull
    public final MutableStateFlow<ProxyData> getProxyData() {
        return this.proxyData;
    }

    private final ProxyStrategy getProxyModeForThisURL(String url) {
        ProxyData usingProxy = (ProxyData)this.proxyData.getValue();
        return switch (WhenMappings.$EnumSwitchMapping$0[usingProxy.getProxyMode().ordinal()]) {
            case 1 -> (ProxyStrategy)ProxyStrategy.Direct.INSTANCE;
            case 2 -> (ProxyStrategy)ProxyStrategy.UseSystem.INSTANCE;
            case 3 -> {
                ProxyWithRules proxyWithRules = usingProxy.getProxyWithRules();
                if (this.shouldUseProxyFor(url, proxyWithRules.getRules())) {
                    yield (ProxyStrategy)new ProxyStrategy.ManualProxy(proxyWithRules.getProxy());
                }
                yield (ProxyStrategy)ProxyStrategy.Direct.INSTANCE;
            }
            case 4 -> {
                String pacURI = usingProxy.getPac().getUri();
                if (UrlUtils.INSTANCE.isValidUrl(pacURI)) {
                    yield (ProxyStrategy)new ProxyStrategy.ByScript(pacURI);
                }
                yield (ProxyStrategy)ProxyStrategy.Direct.INSTANCE;
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean shouldUseProxyFor(String url, ProxyRules rules) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = rules.getExcludeURLPatterns();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringUtilKt.wildcardMatch((String)it, (String)url)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        boolean isInExcludeList = bl;
        return !isInExcludeList;
    }

    @NotNull
    public ProxyStrategy getProxyStrategyFor(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getProxyModeForThisURL(url);
    }

    private static final Proxy _init_$lambda$0(ProxyManager this$0) {
        return ((ProxyData)this$0.proxyData.getValue()).getProxyWithRules().getProxy();
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProxyMode.values().length];
            try {
                nArray[ProxyMode.Direct.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyMode.UseSystem.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyMode.Manual.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProxyMode.Pac.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

