/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.shared.utils.extractors.linkextractor;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.shared.utils.extractors.Extractor;
import ir.amirab.util.UrlUtils;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\b\u00c7\u0002\u0018\u00002\u0014\u0012\u0004\u0012\u00020\u0002\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0016J\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0002J\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00020\u00032\u0006\u0010\r\u001a\u00020\u0002H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0010"}, d2={"Lcom/abdownloadmanager/shared/utils/extractors/linkextractor/StringUrlExtractor;", "Lcom/abdownloadmanager/shared/utils/extractors/Extractor;", "", "", "<init>", "()V", "urlRegex", "Lkotlin/text/Regex;", "getUrlRegex", "()Lkotlin/text/Regex;", "urlRegex$delegate", "Lkotlin/Lazy;", "extract", "input", "byEachLine", "byRegex", "app-utils"})
@StabilityInferred(parameters=0)
public final class StringUrlExtractor
implements Extractor<String, List<? extends String>> {
    @NotNull
    public static final StringUrlExtractor INSTANCE = new StringUrlExtractor();
    @NotNull
    private static final Lazy urlRegex$delegate = LazyKt.lazy(StringUrlExtractor::urlRegex_delegate$lambda$0);
    public static final int $stable = 8;

    private StringUrlExtractor() {
    }

    private final Regex getUrlRegex() {
        Lazy lazy = urlRegex$delegate;
        return (Regex)lazy.getValue();
    }

    @Override
    @NotNull
    public List<String> extract(@NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        List<String> linksInEachLines = this.byEachLine(input);
        if (!((Collection)linksInEachLines).isEmpty()) {
            return linksInEachLines;
        }
        return this.byRegex(input);
    }

    private final List<String> byEachLine(String input) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)StringsKt.lineSequence((CharSequence)input), StringUrlExtractor::byEachLine$lambda$1), StringUrlExtractor::byEachLine$lambda$2));
    }

    private final List<String> byRegex(String input) {
        return SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)SequencesKt.map((Sequence)Regex.findAll$default((Regex)this.getUrlRegex(), (CharSequence)input, (int)0, (int)2, null), StringUrlExtractor::byRegex$lambda$3), StringUrlExtractor::byRegex$lambda$4));
    }

    private static final Regex urlRegex_delegate$lambda$0() {
        return new Regex("\\b(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    }

    private static final String byEachLine$lambda$1(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ((Object)StringsKt.trim((CharSequence)it)).toString();
    }

    private static final boolean byEachLine$lambda$2(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UrlUtils.INSTANCE.isValidUrl(it);
    }

    private static final String byRegex$lambda$3(MatchResult it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getValue();
    }

    private static final boolean byRegex$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return UrlUtils.INSTANCE.isValidUrl(it);
    }
}

