/*
 * Decompiled with CFR 0.152.
 */
package com.abdownloadmanager.shared.utils.category;

import androidx.compose.runtime.internal.StabilityInferred;
import com.abdownloadmanager.shared.utils.category.Category;
import com.abdownloadmanager.shared.utils.category.CategoryItemWithId;
import com.abdownloadmanager.shared.utils.category.CategoryManager;
import com.abdownloadmanager.shared.utils.category.CategoryManagerKt;
import com.abdownloadmanager.shared.utils.category.CategoryStorage;
import com.abdownloadmanager.shared.utils.category.DefaultCategories;
import com.abdownloadmanager.shared.utils.category.ICategoryItem;
import com.abdownloadmanager.shared.utils.category.ICategoryItemProvider;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 @2\u00020\u0001:\u0001@B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000e\u0010\u0016\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\u000e\u0010\u0019\u001a\u00020\u0017H\u0086@\u00a2\u0006\u0002\u0010\u0018J\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0014\u0010\u001b\u001a\u00020\u00172\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u0004\u0018\u00010\u000f2\u0006\u0010!\u001a\u00020\"J\u0010\u0010#\u001a\u0004\u0018\u00010\u000f2\u0006\u0010$\u001a\u00020\"J\u0010\u0010%\u001a\u0004\u0018\u00010\u000f2\u0006\u0010&\u001a\u00020'J\u0010\u0010(\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u000fJ\u000e\u0010)\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001fJ\u000e\u0010,\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u000fJ\u0010\u0010-\u001a\u00020\u00172\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0010\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u000fH\u0002J\u000e\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020\u000fJ\"\u00100\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001f2\u0012\u00101\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f02J\u001c\u00103\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u001f2\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000eJ\u0014\u00105\u001a\u00020\u00172\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001f0\u000eJ\u000e\u00107\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u000fJ\u0014\u00108\u001a\u00020\u00172\f\u00109\u001a\b\u0012\u0004\u0012\u00020:0\u000eJ\u000e\u0010;\u001a\u00020\u00152\u0006\u0010<\u001a\u00020\"J\u0016\u0010=\u001a\u00020\u00172\u0006\u0010>\u001a\u00020\"2\u0006\u0010?\u001a\u00020\"R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lcom/abdownloadmanager/shared/utils/category/CategoryManager;", "", "categoryStorage", "Lcom/abdownloadmanager/shared/utils/category/CategoryStorage;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "defaultCategoriesFactory", "Lcom/abdownloadmanager/shared/utils/category/DefaultCategories;", "categoryItemProvider", "Lcom/abdownloadmanager/shared/utils/category/ICategoryItemProvider;", "<init>", "(Lcom/abdownloadmanager/shared/utils/category/CategoryStorage;Lkotlinx/coroutines/CoroutineScope;Lcom/abdownloadmanager/shared/utils/category/DefaultCategories;Lcom/abdownloadmanager/shared/utils/category/ICategoryItemProvider;)V", "_categories", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/abdownloadmanager/shared/utils/category/Category;", "categoriesFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getCategoriesFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "booted", "", "boot", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "reset", "getCategories", "setCategories", "categories", "getCategoryById", "id", "", "getCategoryOfType", "extension", "", "getCategoryOfFileName", "fileName", "getCategoryOf", "categoryItem", "Lcom/abdownloadmanager/shared/utils/category/ICategoryItem;", "getCategoryOfItem", "deleteCategory", "category", "categoryId", "addCustomCategory", "createDirectoryIfNecessary", "prepareCategory", "newCategory", "updateCategory", "categoryToUpdate", "Lkotlin/Function1;", "addItemsToCategory", "itemIds", "removeItemInCategories", "idsToRemove", "isDefaultCategory", "autoAddItemsToCategoriesBasedOnFileNames", "unCategorizedItems", "Lcom/abdownloadmanager/shared/utils/category/CategoryItemWithId;", "isThisPathBelongsToACategory", "folder", "updateCategoryFoldersBasedOnDefaultDownloadFolder", "previousDownloadFolder", "currentDownloadFolder", "Companion", "app-utils"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nCategoryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CategoryManager.kt\ncom/abdownloadmanager/shared/utils/category/CategoryManager\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 CategoryManager.kt\ncom/abdownloadmanager/shared/utils/category/CategoryManagerKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,265:1\n230#2,5:266\n230#2,3:288\n233#2,2:294\n230#2,3:297\n233#2,2:308\n230#2,3:310\n233#2,2:321\n230#2,3:323\n233#2,2:334\n230#2,5:336\n295#3,2:271\n295#3:273\n1761#3,3:274\n296#3:277\n295#3,2:278\n774#3:280\n865#3,2:281\n774#3:283\n865#3,2:284\n295#3,2:286\n774#3:291\n865#3,2:292\n1563#3:301\n1634#3,2:302\n1636#3:307\n1563#3:314\n1634#3,2:315\n1636#3:320\n1563#3:327\n1634#3,2:328\n1636#3:333\n1617#3,9:348\n1869#3:357\n1870#3:359\n1626#3:360\n1#4:296\n1#4:358\n259#5:300\n260#5,3:304\n259#5:313\n260#5,3:317\n259#5:326\n260#5,3:330\n382#6,7:341\n*S KotlinDebug\n*F\n+ 1 CategoryManager.kt\ncom/abdownloadmanager/shared/utils/category/CategoryManager\n*L\n58#1:266,5\n114#1:288,3\n114#1:294,2\n159#1:297,3\n159#1:308,2\n168#1:310,3\n168#1:321,2\n175#1:323,3\n175#1:334,2\n185#1:336,5\n63#1:271,2\n67#1:273\n68#1:274,3\n67#1:277\n76#1:278,2\n85#1:280\n85#1:281,2\n86#1:283\n86#1:284,2\n104#1:286,2\n115#1:291\n115#1:292,2\n160#1:301\n160#1:302,2\n160#1:307\n169#1:314\n169#1:315,2\n169#1:320\n178#1:327\n178#1:328,2\n178#1:333\n215#1:348,9\n215#1:357\n215#1:359\n215#1:360\n215#1:358\n160#1:300\n160#1:304,3\n169#1:313\n169#1:317,3\n178#1:326\n178#1:330,3\n202#1:341,7\n*E\n"})
public final class CategoryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CategoryStorage categoryStorage;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final DefaultCategories defaultCategoriesFactory;
    @NotNull
    private final ICategoryItemProvider categoryItemProvider;
    @NotNull
    private final MutableStateFlow<List<Category>> _categories;
    @NotNull
    private final StateFlow<List<Category>> categoriesFlow;
    private boolean booted;
    public static final int $stable = 8;
    public static final long DEFAULT_CATEGORY_END_ID = 100L;

    public CategoryManager(@NotNull CategoryStorage categoryStorage, @NotNull CoroutineScope scope, @NotNull DefaultCategories defaultCategoriesFactory, @NotNull ICategoryItemProvider categoryItemProvider) {
        Intrinsics.checkNotNullParameter((Object)categoryStorage, (String)"categoryStorage");
        Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
        Intrinsics.checkNotNullParameter((Object)defaultCategoriesFactory, (String)"defaultCategoriesFactory");
        Intrinsics.checkNotNullParameter((Object)categoryItemProvider, (String)"categoryItemProvider");
        this.categoryStorage = categoryStorage;
        this.scope = scope;
        this.defaultCategoriesFactory = defaultCategoriesFactory;
        this.categoryItemProvider = categoryItemProvider;
        this._categories = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.categoriesFlow = FlowKt.asStateFlow(this._categories);
    }

    @NotNull
    public final StateFlow<List<Category>> getCategoriesFlow() {
        return this.categoriesFlow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object boot(@NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof boot.1)) ** GOTO lbl-1000
        var8_2 = $completion;
        if ((var8_2.label & -2147483648) != 0) {
            var8_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ CategoryManager this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.boot((Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var9_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                var2_5 = this;
                synchronized (var2_5) {
                    $i$a$-synchronized-CategoryManager$boot$2 = false;
                    if (!this.booted) ** GOTO lbl23
                    var5_8 = Unit.INSTANCE;
                    return var5_8;
lbl23:
                    // 2 sources

                    var3_7 = Unit.INSTANCE;
                }
                $continuation.label = 1;
                v0 = this.categoryStorage.isCategoriesSet((Continuation<? super Boolean>)$continuation);
                if (v0 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl34
            }
            case 1: {
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                if (!((Boolean)v0).booleanValue()) break;
                $continuation.L$0 = var6_10 = this._categories;
                $continuation.label = 2;
                v1 = this.categoryStorage.getCategories((Continuation<? super List<Category>>)$continuation);
                if (v1 == var9_4) {
                    return var9_4;
                }
                ** GOTO lbl45
            }
            case 2: {
                var6_10 = (MutableStateFlow<List<Category>>)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl45:
                // 2 sources

                var6_10.setValue(v1);
                ** GOTO lbl55
            }
        }
        $continuation.label = 3;
        v2 = this.reset((Continuation<? super Unit>)$continuation);
        if (v2 == var9_4) {
            return var9_4;
        }
        ** GOTO lbl55
        {
            case 3: {
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl55:
                // 3 sources

                FlowKt.launchIn((Flow)FlowKt.onEach((Flow)FlowKt.sample((Flow)((Flow)this._categories), (long)500L), (Function2)((Function2)new Function2<List<? extends Category>, Continuation<? super Unit>, Object>(this, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ CategoryManager this$0;
                    {
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        List list = (List)this.L$0;
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                void it;
                                ResultKt.throwOnFailure((Object)$result);
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)it);
                                this.label = 1;
                                Object object2 = CategoryManager.access$getCategoryStorage$p(this.this$0).setCategories((List<Category>)it, (Continuation<? super Unit>)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(List<Category> p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                })), (CoroutineScope)this.scope);
                this.booted = true;
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @Nullable
    public final Object reset(@NotNull Continuation<? super Unit> $completion) {
        List<Category> newCategories = this.defaultCategoriesFactory.getDefaultCategories();
        this.setCategories(newCategories);
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(newCategories, this, null){
            Object L$0;
            int label;
            final /* synthetic */ List<Category> $newCategories;
            final /* synthetic */ CategoryManager this$0;
            {
                this.$newCategories = $newCategories;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var10_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        var2_3 = this.$newCategories;
                        var3_4 = this.this$0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            it = (Category)element$iv;
                            $i$a$-forEach-CategoryManager$reset$2$1 = false;
                            CategoryManager.access$prepareCategory(var3_4, it);
                        }
                        var9_10 = this.this$0;
                        this.L$0 = var9_10;
                        this.label = 1;
                        v0 = CategoryManager.access$getCategoryItemProvider$p(this.this$0).getAll((Continuation<? super List<CategoryItemWithId>>)((Continuation)this));
                        if (v0 == var10_2) {
                            return var10_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        var9_10 = (CategoryManager)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        var9_10.autoAddItemsToCategoriesBasedOnFileNames((List)v0);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final List<Category> getCategories() {
        return (List)this._categories.getValue();
    }

    public final void setCategories(@NotNull List<Category> categories) {
        List<Category> nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(categories, (String)"categories");
        MutableStateFlow<List<Category>> $this$update$iv = this._categories;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            List it = (List)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, nextValue$iv = categories));
    }

    @Nullable
    public final Category getCategoryById(long id) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getCategories();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Category it = (Category)element$iv;
                boolean bl = false;
                if (!(it.getId() == id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Category getCategoryOfType(@NotNull String extension) {
        Object v1;
        block5: {
            Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
            Iterable $this$firstOrNull$iv = this.getCategories();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                boolean bl;
                block4: {
                    Category c = (Category)element$iv;
                    boolean bl2 = false;
                    Iterable $this$any$iv = c.getAcceptedFileTypes();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv2 : $this$any$iv) {
                            String it = (String)element$iv2;
                            boolean bl3 = false;
                            if (!StringsKt.equals((String)it, (String)extension, (boolean)true)) continue;
                            bl = true;
                            break block4;
                        }
                        bl = false;
                    }
                }
                if (!bl) continue;
                v1 = element$iv;
                break block5;
            }
            v1 = null;
        }
        return v1;
    }

    @Nullable
    public final Category getCategoryOfFileName(@NotNull String fileName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
            Iterable $this$firstOrNull$iv = this.getCategories();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Category it = (Category)element$iv;
                boolean bl = false;
                if (!it.acceptFileName(fileName)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Category getCategoryOf(@NotNull ICategoryItem categoryItem) {
        Category it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)categoryItem, (String)"categoryItem");
        String url = categoryItem.getUrl();
        String fileName = categoryItem.getFileName();
        Object object = this.getCategories();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Category)element$iv$iv;
            boolean bl = false;
            if (!it.getHasFilters()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Category)element$iv$iv;
            boolean bl = false;
            if (!(it.acceptFileName(fileName) && it.acceptUrl(url))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        object = new Comparator(){

            public final int compare(T a, T b) {
                Category it = (Category)b;
                boolean bl = false;
                Comparable comparable = Boolean.valueOf(it.getHasUrlPattern());
                it = (Category)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getHasUrlPattern()));
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Category it = (Category)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getAcceptedUrlPatterns().size());
                    it = (Category)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getAcceptedUrlPatterns().size()));
                }
                return n;
            }
        };
        object = new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenByDescending;
            {
                this.$this_thenByDescending = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenByDescending.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Category it = (Category)b;
                    boolean bl = false;
                    Comparable comparable = Boolean.valueOf(it.getHasFileTypes());
                    it = (Category)a;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Boolean.valueOf(it.getHasFileTypes()));
                }
                return n;
            }
        };
        return (Category)CollectionsKt.firstOrNull((List)CollectionsKt.sortedWith((Iterable)((List)destination$iv$iv), (Comparator)new Comparator((Comparator)object){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Category it = (Category)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getAcceptedFileTypes().size());
                    it = (Category)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getAcceptedFileTypes().size()));
                }
                return n;
            }
        }));
    }

    @Nullable
    public final Category getCategoryOfItem(long id) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.getCategories();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Category it = (Category)element$iv;
                boolean bl = false;
                if (!it.getItems().contains(id)) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void deleteCategory(@NotNull Category category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        this.deleteCategory(category.getId());
    }

    /*
     * WARNING - void declaration
     */
    public final void deleteCategory(long categoryId) {
        Collection destination$iv$iv;
        List nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<List<Category>> $this$update$iv = this._categories;
        boolean $i$f$update = false;
        do {
            void $this$filterTo$iv$iv;
            prevValue$iv = $this$update$iv.getValue();
            List it = (List)prevValue$iv;
            boolean bl = false;
            Iterable $this$filter$iv = it;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Category it2 = (Category)element$iv$iv;
                boolean bl2 = false;
                if (!(it2.getId() != categoryId)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (List)destination$iv$iv)));
    }

    public final void addCustomCategory(@NotNull Category category) {
        Comparable comparable;
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        if (!(category.getId() == -1L)) {
            String string2 = "Failed requirement.";
            throw new IllegalArgumentException(string2.toString());
        }
        List<Category> categories = this.getCategories();
        Iterator iterator = ((Iterable)categories).iterator();
        if (!iterator.hasNext()) {
            comparable = null;
        } else {
            Category it = (Category)iterator.next();
            boolean bl = false;
            Comparable comparable2 = Long.valueOf(it.getId());
            while (iterator.hasNext()) {
                Category it2 = (Category)iterator.next();
                $i$a$-maxOfOrNull-CategoryManager$addCustomCategory$newId$1 = false;
                Comparable comparable3 = Long.valueOf(it2.getId());
                if (comparable2.compareTo(comparable3) >= 0) continue;
                comparable2 = comparable3;
            }
            comparable = comparable2;
        }
        Long l = (Long)comparable;
        long newId = (l != null ? RangesKt.coerceAtLeast((long)l, (long)100L) : 100L) + 1L;
        Category newCategory = Category.copy$default(category, newId, null, null, null, false, null, null, null, 254, null);
        this.setCategories(CollectionsKt.plus((Collection)categories, (Object)newCategory));
        this.prepareCategory(newCategory);
    }

    private final void createDirectoryIfNecessary(Category category) {
        try {
            File file;
            block7: {
                block6: {
                    boolean bl = false;
                    String string2 = category.getDownloadPath();
                    if (string2 == null) break block6;
                    String p0 = string2;
                    boolean bl2 = false;
                    file = new File(p0).getCanonicalFile();
                    if (file != null) break block7;
                }
                return;
            }
            File folder = file;
            if (!folder.exists()) {
                folder.mkdirs();
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
    }

    private final void prepareCategory(Category newCategory) {
        this.createDirectoryIfNecessary(newCategory);
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCategory(@NotNull Category categoryToUpdate) {
        Collection destination$iv$iv$iv;
        List nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter((Object)categoryToUpdate, (String)"categoryToUpdate");
        MutableStateFlow<List<Category>> $this$update$iv = this._categories;
        boolean $i$f$update = false;
        do {
            void $this$mapTo$iv$iv$iv;
            void $this$updatedItem$iv;
            prevValue$iv = $this$update$iv.getValue();
            List it = (List)prevValue$iv;
            boolean bl = false;
            List list = it;
            long l = categoryToUpdate.getId();
            boolean $i$f$updatedItem = false;
            Iterable $this$map$iv$iv = (Iterable)$this$updatedItem$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                Category category;
                void categoryId$iv;
                void it$iv;
                Category category2 = (Category)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                if (it$iv.getId() == categoryId$iv) {
                    void it2 = it$iv;
                    boolean bl3 = false;
                    category = categoryToUpdate;
                } else {
                    category = it$iv;
                }
                collection.add(category);
            }
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (List)destination$iv$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    public final void updateCategory(long id, @NotNull Function1<? super Category, Category> categoryToUpdate) {
        Collection destination$iv$iv$iv;
        List nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(categoryToUpdate, (String)"categoryToUpdate");
        MutableStateFlow<List<Category>> $this$update$iv = this._categories;
        boolean $i$f$update = false;
        do {
            void $this$mapTo$iv$iv$iv;
            void $this$updatedItem$iv;
            prevValue$iv = $this$update$iv.getValue();
            List it = (List)prevValue$iv;
            boolean bl = false;
            List list = it;
            long categoryId$iv = id;
            boolean $i$f$updatedItem = false;
            Iterable $this$map$iv$iv = (Iterable)$this$updatedItem$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                void it$iv;
                Category category = (Category)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                collection.add(it$iv.getId() == categoryId$iv ? (Category)categoryToUpdate.invoke((Object)it$iv) : it$iv);
            }
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (List)destination$iv$iv$iv)));
    }

    /*
     * WARNING - void declaration
     */
    public final void addItemsToCategory(long categoryId, @NotNull List<Long> itemIds) {
        Collection destination$iv$iv$iv;
        List nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(itemIds, (String)"itemIds");
        MutableStateFlow<List<Category>> $this$update$iv = this._categories;
        boolean $i$f$update = false;
        do {
            void $this$mapTo$iv$iv$iv;
            void $this$updatedItem$iv;
            prevValue$iv = $this$update$iv.getValue();
            List previousCategories = (List)prevValue$iv;
            boolean bl = false;
            List list = CategoryManagerKt.access$removedItemIds(previousCategories, itemIds);
            long categoryId$iv = categoryId;
            boolean $i$f$updatedItem = false;
            Iterable $this$map$iv$iv = (Iterable)$this$updatedItem$iv;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv$iv;
            destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
                Category category;
                void it$iv;
                Category category2 = (Category)item$iv$iv$iv;
                Collection collection = destination$iv$iv$iv;
                boolean bl2 = false;
                if (it$iv.getId() == categoryId$iv) {
                    void it = it$iv;
                    boolean bl3 = false;
                    category = it.withExtraItems(itemIds);
                } else {
                    category = it$iv;
                }
                collection.add(category);
            }
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = (List)destination$iv$iv$iv)));
    }

    public final void removeItemInCategories(@NotNull List<Long> idsToRemove) {
        List it;
        List nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(idsToRemove, (String)"idsToRemove");
        MutableStateFlow<List<Category>> $this$update$iv = this._categories;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (List)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = CategoryManagerKt.access$removedItemIds(it, idsToRemove))));
    }

    public final boolean isDefaultCategory(@NotNull Category category) {
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        long l = category.getId();
        return 0L <= l ? l < 101L : false;
    }

    /*
     * WARNING - void declaration
     */
    public final void autoAddItemsToCategoriesBasedOnFileNames(@NotNull List<CategoryItemWithId> unCategorizedItems) {
        Intrinsics.checkNotNullParameter(unCategorizedItems, (String)"unCategorizedItems");
        Map newItemsMap = new LinkedHashMap();
        int count = 0;
        for (CategoryItemWithId entry : unCategorizedItems) {
            Object object;
            void $this$getOrPut$iv;
            Category categoryToUpdate;
            if (this.getCategoryOf(entry) == null) continue;
            Map map2 = newItemsMap;
            Long key$iv = categoryToUpdate.getId();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((List)object).add(entry.getId());
            ++count;
        }
        for (Map.Entry entry : newItemsMap.entrySet()) {
            long categoryId = ((Number)entry.getKey()).longValue();
            List itemsToAdd = (List)entry.getValue();
            this.updateCategory(categoryId, (Function1<? super Category, Category>)((Function1)arg_0 -> CategoryManager.autoAddItemsToCategoriesBasedOnFileNames$lambda$24(itemsToAdd, arg_0)));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isThisPathBelongsToACategory(@NotNull String folder) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)folder, (String)"folder");
        Iterable $this$mapNotNull$iv = this.getCategories();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            Category it = (Category)element$iv$iv;
            boolean bl2 = false;
            if (it.getDownloadPath() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return ((List)destination$iv$iv).contains(folder);
    }

    public final void updateCategoryFoldersBasedOnDefaultDownloadFolder(@NotNull String previousDownloadFolder, @NotNull String currentDownloadFolder) {
        Intrinsics.checkNotNullParameter((Object)previousDownloadFolder, (String)"previousDownloadFolder");
        Intrinsics.checkNotNullParameter((Object)currentDownloadFolder, (String)"currentDownloadFolder");
        File previousDownloadFolder2 = new File(previousDownloadFolder).getAbsoluteFile();
        File currentDownloadFolder2 = new File(currentDownloadFolder).getAbsoluteFile();
        for (Category category : this.getCategories()) {
            File categoryPath = new File(category.getPath()).getAbsoluteFile();
            Intrinsics.checkNotNull((Object)categoryPath);
            Intrinsics.checkNotNull((Object)previousDownloadFolder2);
            if (!FilesKt.startsWith((File)categoryPath, (File)previousDownloadFolder2)) continue;
            File relativePath = FilesKt.relativeTo((File)categoryPath, (File)previousDownloadFolder2);
            this.updateCategory(category.getId(), (Function1<? super Category, Category>)((Function1)arg_0 -> CategoryManager.updateCategoryFoldersBasedOnDefaultDownloadFolder$lambda$26(currentDownloadFolder2, relativePath, arg_0)));
        }
    }

    private static final Category autoAddItemsToCategoriesBasedOnFileNames$lambda$24(List $itemsToAdd, Category it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.withExtraItems($itemsToAdd);
    }

    private static final Category updateCategoryFoldersBasedOnDefaultDownloadFolder$lambda$26(File $currentDownloadFolder, File $relativePath, Category it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Intrinsics.checkNotNull((Object)$currentDownloadFolder);
        String string2 = FilesKt.resolve((File)$currentDownloadFolder, (File)$relativePath).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return Category.copy$default(it, 0L, null, null, string2, false, null, null, null, 247, null);
    }

    public static final /* synthetic */ CategoryStorage access$getCategoryStorage$p(CategoryManager $this) {
        return $this.categoryStorage;
    }

    public static final /* synthetic */ ICategoryItemProvider access$getCategoryItemProvider$p(CategoryManager $this) {
        return $this.categoryItemProvider;
    }

    public static final /* synthetic */ void access$prepareCategory(CategoryManager $this, Category newCategory) {
        $this.prepareCategory(newCategory);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/abdownloadmanager/shared/utils/category/CategoryManager$Companion;", "", "<init>", "()V", "DEFAULT_CATEGORY_END_ID", "", "app-utils"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

