/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.markdown.utils;

import androidx.compose.runtime.internal.StabilityInferred;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.intellij.markdown.html.entities.Entities;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\t\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/mikepenz/markdown/utils/EntityConverter;", "", "<init>", "()V", "ESCAPE_ALLOWED_STRING", "", "REGEX", "Lkotlin/text/Regex;", "REGEX_ESCAPES", "replaceEntities", "text", "", "processEntities", "", "processEscapes", "multiplatform-markdown-renderer"})
@StabilityInferred(parameters=0)
public final class EntityConverter {
    @NotNull
    public static final EntityConverter INSTANCE = new EntityConverter();
    @NotNull
    private static final String ESCAPE_ALLOWED_STRING = "!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~";
    @NotNull
    private static final Regex REGEX = new Regex("&(?:([a-zA-Z0-9]+)|#([0-9]{1,8})|#[xX]([a-fA-F0-9]{1,8}));|([\"&<>])");
    @NotNull
    private static final Regex REGEX_ESCAPES = new Regex(REGEX.getPattern() + "|\\\\([!\"#\\$%&'\\(\\)\\*\\+,\\-.\\/:;<=>\\?@\\[\\\\\\]\\^_`{\\|}~])");
    public static final int $stable = 8;

    private EntityConverter() {
    }

    @NotNull
    public final String replaceEntities(@NotNull CharSequence text, boolean processEntities, boolean processEscapes) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Regex regex = processEscapes ? REGEX_ESCAPES : REGEX;
        return regex.replace(text, arg_0 -> EntityConverter.replaceEntities$lambda$0(processEntities, arg_0));
    }

    private static final CharSequence replaceEntities$lambda$0(boolean $processEntities, MatchResult match) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)match, (String)"match");
        MatchGroupCollection g = match.getGroups();
        if (g.size() > 5 && g.get(5) != null) {
            MatchGroup matchGroup = g.get(5);
            Intrinsics.checkNotNull((Object)matchGroup);
            charSequence = String.valueOf(matchGroup.getValue().charAt(0));
        } else if (g.get(4) != null) {
            charSequence = match.getValue();
        } else {
            Integer code;
            Object object;
            Integer n;
            if (!$processEntities) {
                n = null;
            } else if (g.get(1) != null) {
                n = (Integer)Entities.INSTANCE.getMap().get(match.getValue());
            } else if (g.get(2) != null) {
                MatchGroup matchGroup = g.get(2);
                Intrinsics.checkNotNull((Object)matchGroup);
                n = Integer.parseInt(matchGroup.getValue());
            } else if (g.get(3) != null) {
                MatchGroup matchGroup = g.get(3);
                Intrinsics.checkNotNull((Object)matchGroup);
                n = Integer.parseInt(matchGroup.getValue(), CharsKt.checkRadix((int)16));
            } else {
                n = null;
            }
            if ((object = (code = n)) == null || (object = Character.valueOf((char)((Integer)object).intValue()).toString()) == null) {
                String string = match.getValue().substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                object = "&" + string;
            }
            charSequence = (CharSequence)object;
        }
        return charSequence;
    }
}

