/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.markdown.model;

import androidx.compose.runtime.Stable;
import com.mikepenz.markdown.model.Input;
import com.mikepenz.markdown.model.MarkdownState;
import com.mikepenz.markdown.model.State;
import com.mikepenz.markdown.utils.ExtensionsKt;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.intellij.markdown.ast.ASTNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b\u0015J\u0015\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u000e\u0010\u001a\u001a\u00020\bH\u0096@\u00a2\u0006\u0002\u0010\u001bJ\r\u0010\u001c\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\"\u0010\r\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u0010\u001a\u0016\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u000e0\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\f\u00a8\u0006\u001e"}, d2={"Lcom/mikepenz/markdown/model/MarkdownStateImpl;", "Lcom/mikepenz/markdown/model/MarkdownState;", "input", "Lcom/mikepenz/markdown/model/Input;", "<init>", "(Lcom/mikepenz/markdown/model/Input;)V", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/mikepenz/markdown/model/State;", "state", "Lkotlinx/coroutines/flow/StateFlow;", "getState", "()Lkotlinx/coroutines/flow/StateFlow;", "linkStateFlow", "", "", "links", "getLinks", "updateInput", "", "newInput", "updateInput$multiplatform_markdown_renderer", "setError", "error", "", "setError$multiplatform_markdown_renderer", "parse", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parseBlocking", "parseBlocking$multiplatform_markdown_renderer", "multiplatform-markdown-renderer"})
@Stable
@SourceDebugExtension(value={"SMAP\nMarkdownState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownState.kt\ncom/mikepenz/markdown/model/MarkdownStateImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,311:1\n640#2:312\n1#3:313\n*S KotlinDebug\n*F\n+ 1 MarkdownState.kt\ncom/mikepenz/markdown/model/MarkdownStateImpl\n*L\n193#1:312\n193#1:313\n*E\n"})
public final class MarkdownStateImpl
implements MarkdownState {
    @NotNull
    private Input input;
    @NotNull
    private final MutableStateFlow<State> stateFlow;
    @NotNull
    private final StateFlow<State> state;
    @NotNull
    private final MutableStateFlow<Map<String, String>> linkStateFlow;
    @NotNull
    private final StateFlow<Map<String, String>> links;
    public static final int $stable;

    public MarkdownStateImpl(@NotNull Input input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        this.input = input;
        this.stateFlow = StateFlowKt.MutableStateFlow((Object)new State.Loading(this.input.getReferenceLinkHandler()));
        this.state = FlowKt.asStateFlow(this.stateFlow);
        this.linkStateFlow = StateFlowKt.MutableStateFlow((Object)MapsKt.emptyMap());
        this.links = FlowKt.asStateFlow(this.linkStateFlow);
    }

    @Override
    @NotNull
    public StateFlow<State> getState() {
        return this.state;
    }

    @Override
    @NotNull
    public StateFlow<Map<String, String>> getLinks() {
        return this.links;
    }

    public final void updateInput$multiplatform_markdown_renderer(@NotNull Input newInput) {
        Intrinsics.checkNotNullParameter((Object)newInput, (String)"newInput");
        this.input = newInput;
        this.stateFlow.setValue((Object)new State.Loading(this.input.getReferenceLinkHandler()));
    }

    public final void setError$multiplatform_markdown_renderer(@NotNull Throwable error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.stateFlow.setValue((Object)new State.Error(error, this.input.getReferenceLinkHandler()));
    }

    @Override
    @Nullable
    public Object parse(@NotNull Continuation<? super State> $completion) {
        return BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super State>, Object>(this, null){
            int label;
            final /* synthetic */ MarkdownStateImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        return this.this$0.parseBlocking$multiplatform_markdown_renderer();
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super State> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    @NotNull
    public final State parseBlocking$multiplatform_markdown_renderer() {
        State state;
        try {
            ASTNode parsedResult = this.input.getParser().buildMarkdownTreeFromString(this.input.getContent());
            if (this.input.getLookupLinks()) {
                Map map;
                Map links = new LinkedHashMap();
                ExtensionsKt.lookupLinkDefinition$default(links, parsedResult, this.input.getContent(), true, false, 16, null);
                Map $this$onEach$iv = links;
                boolean $i$f$onEach = false;
                Map $this$onEach_u24lambda_u242$iv = map = $this$onEach$iv;
                boolean bl = false;
                Iterator iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator.next();
                    boolean bl2 = false;
                    String key = (String)entry.getKey();
                    String value = (String)entry.getValue();
                    this.input.getReferenceLinkHandler().store(key, value);
                }
                this.linkStateFlow.setValue((Object)links);
            }
            state = new State.Success(parsedResult, this.input.getContent(), this.input.getLookupLinks(), this.input.getReferenceLinkHandler());
        }
        catch (Throwable error) {
            state = new State.Error(error, this.input.getReferenceLinkHandler());
        }
        State result = state;
        boolean bl = false;
        this.stateFlow.setValue((Object)result);
        return state;
    }
}

